# Measurement program Kun Zuo & Vincent Mourik
# Last updated: May 2012

# We use this script for transport measurements, both DC and AC,
# as a function of 1 or 2 other variables. Its well suited to measure 
# with 1 or 2 Keithleys and/or 1 or 2 Lockins in 2 or 4 terminal geometries.
# If you are a first time user, we recommend scrolling down to the 
# 'initialization' part of the script, we put some usefull comments there.
# Comments/improvements are appreciated.

# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.



from numpy import pi, random, arange, size, array, sin, cos, linspace, sinc, sqrt, log10, power, abs, matrix, radians
from time import time, sleep
from shutil import copyfile
from os import mkdir
from os.path import exists
from lib.file_support.spyview import SpyView
from datetime import timedelta


import qt
import timetrack
import sys
import numpy as np
import data as d
import traces
import shutil
import os
import math
import time

keithley1 = qt.instruments.get('keithley1')
keithley2 = qt.instruments.get('keithley2')
lockin1 = qt.instruments.get('lockin1')
lockin2 = qt.instruments.get('lockin2')
ivvi = qt.instruments.get('ivvi')
cryomag = qt.instruments.get('magnetsupply')
lakeshore = qt.instruments.get('lakeshore')
#kepco = qt.instruments.get('kepco')
#mw = qt.instruments.get('mw')



    
class majorana():
    
        # Function generates data file, spyview file and copies the python script.
    def create_data(self,x_vector,x_coordinate,x_parameter,y_vector,y_coordinate,y_parameter,z_vector,z_coordinate,z_parameter):
        self.filename=filename
        self.generator=d.IncrementalGenerator(qt.config['datadir']+'\\'+filename,1);
        qt.Data.set_filename_generator(self.generator)
        self.filename_full = self.filename+"_"+str(self.generator._counter)
        print "Current filename: "+self.filename_full
        data = qt.Data(name=self.filename)
        '''
        multiplier = eval('multiplier'+x_parameter)
        if xmultiplier == 0.01:
            unitmultiplier = 1e-3
        elseif == 1e-3:
            unitmultiplier = 1e-6
        else:
            unitmultiplier = 1
        
        x
        '''
        data.add_coordinate(x_parameter+' ('+x_coordinate+')',
                            size=len(x_vector),
                            start=x_vector[0],
                            end=x_vector[-1]) 
        data.add_coordinate(y_parameter+' ('+y_coordinate+')',
                            size=len(y_vector),
                            start=y_vector[0],
                            end=y_vector[-1]) 
        data.add_coordinate(z_parameter+' ('+z_coordinate+')',
                            size=len(z_vector),
                            start=z_vector[0],
                            end=z_vector[-1])
        data.add_value('processed data Keithley1')          # Processed data Keithley 1
        data.add_value('processed data Keithley2')          # Processed data Keithley 2
        data.add_value('processed data Lockin1')            # Processed data Lockin 1
        data.add_value('processed data Lockin2')            # Processed data Lockin 2
        data.add_value('Keithley 1')                        # Read out of Keithley 1
        data.add_value('Keithley 2')                        # Read out of Keithley 2
        data.add_value('X Lockin 1')                        # Read out of R Lockin 1 
        data.add_value('Y Lockin 1')                    # Read out of Theta Lockin 1
        data.add_value('X Lockin 2')                        # Read out of R Lockin 2
        data.add_value('Y Lockin 2')                    # Read out of Theta Lockin 2
        data.add_value('Tail temperature')                  # Fridge temperature
        data.create_file()                                  # Create data file
        SpyView(data).write_meta_file()                     # Create the spyview meta.txt file
        # The above function has a mistake in the native SpyView module
        # Please go to D:\qtlab-0.3\source\lib\file_support\spyview.py on Vector Janis and check the correct version
        traces.copy_script(sys._getframe().f_code.co_filename,data._dir,filename+'_'+str(self.generator._counter-1))           # Copy the python script into the data folder
        return data
    
    
    # Function reads out relevant data
    def take_data(self,dacx,x):
        
        ivvi.set(dacx,x)                                                            # Set specified dac to specified value, has to be done here because of delays needed for Lockin measurements
        
        if Nkeithleys == 0:
            
            if Nlockins == 0:
                print 'Why are you using this function if you dont want to read out any Keithley or Lockin...'
                qt.msleep(3.0)
                sys.exit()
            
            elif Nlockins == 1:
                qt.msleep(delay2)                                                       # Use explained at bottom of the script
                #RL1 = lockin1.get_R()                                                   # Read out R Lockin1
                #thetaL1 = lockin1.get_P()                                               # Read out theta Lockin1
                XL1 = lockin1.get_X()
                YL1 = lockin1.get_Y()
                valueL1 = (XL1/GainL1)/(amplitude1/sqrt(2)-(XL1/GainL1)*RsL1)           # Process data Lockin1
                datavalues = [0,0,valueL1,0,0,0,XL1,YL1,0,0]
                qt.msleep(0.01)
            
            elif Nlockins == 2:
                qt.msleep(delay2)                                                       # Use explained at bottom of the script
                XL1 = lockin1.get_X()                                                   # Read out Lockin1
                YL1 = lockin1.get_Y()                                               # Read out theta Lockin1
                XL2 = lockin2.get_X()                                                   # Read out Lockin2
                YL2 = lockin2.get_Y()                                               # Read out theta Lockin2
                valueL1 = (XL1/GainL1)/(amplitude1/sqrt(2)-(XL1/GainL1)*RsL1)           # Process data Lockin1
                valueL2 = (XL2/GainL2)/(amplitude2/sqrt(2)-(XL2/GainL2)*RsL2)           # Process data Lockin2
                datavalues = [0,0,valueL1,valueL2,0,0,XL1,YL1,XL2,YL2]
                qt.msleep(0.01)
        
        elif Nkeithleys == 1:
            
            if Nlockins == 0:
                K1 = keithley1.get_readnextval()                                        # Read out Keithley1            
                valueK1 = K1/GainK1                                                     # Process data Keithley1
                datavalues = [0,0,valueK1,0,0,0,K1,0,0,0]
                qt.msleep(0.01)
            
            elif Nlockins == 1:
                qt.msleep(delay2)                                                       # Use explained at bottom of the script
                K1 = keithley1.get_readlastval()                                        # Read out Keithley1
                XL1 = lockin1.get_X()                                                   # Read out R Lockin1
                YL1 = lockin1.get_Y()                                               # Read out theta Lockin1
                valueK1 = K1/GainK1                                                     # Process data Keithley1
                valueL1 = (XL1/GainL1)/(amplitude1/sqrt(2)-(XL1/GainL1)*RsL1)           # Process data Lockin1
                datavalues = [valueK1,0,valueL1,0,K1,0,XL1,YL1,0,0]
                qt.msleep(0.01)
            
            elif Nlockins == 2:
                qt.msleep(delay2)                                                       # Use explained at bottom of the script
                K1 = keithley1.get_readnextval()                                        # Read out Keithley1
                XL1 = lockin1.get_X()                                                   # Read out Lockin1
                YL1 = lockin1.get_Y()                                               # Read out theta Lockin1
                XL2 = lockin2.get_X()                                                   # Read out Lockin2
                YL2 = lockin2.get_Y()                                               # Read out theta Lockin2
                valueK1 = K1/GainK1                                                     # Process data Keithley1
                valueL1 = (XL1/GainL1)/(amplitude1/sqrt(2)-(XL1/GainL1)*RsL1)           # Process data Lockin1
                valueL2 = (XL2/GainL2)/(amplitude2/sqrt(2)-(XL2/GainL2)*RsL2)           # Process data Lockin2value = (L1/GainL1)*(GainL2/L2)                                      # Process the data
                datavalues = [valueK1,0,valueL1,valueL2,K1,0,XL1,YL1,XL2,YL2]
                qt.msleep(0.01)
            
        elif Nkeithleys == 2:
            
            if Nlockins == 0:
                K1 = keithley1.get_readnextval()                                        # Read out Keithley1
                K2 = keithley2.get_readnextval()                                        # Read out Keithley2
                valueK1 = K1/GainK1                                                     # Process data Keithley1
                valueK2 = K2/GainK2  
                                                                                        # Process data Keithley2
                if dacx == 'dac1':
                    G1 = valueK1/(x*Vrange*0.001-valueK1*RsL1)
                    G2 = valueK2/(x*Vrange*0.001-valueK2*RsL2)
                else: 
                    G1 = valueK1/(ivvi.get('dac1')*Vrange*0.001-valueK1*RsL1)
                    G2 = valueK2/(ivvi.get('dac1')*Vrange*0.001-valueK2*RsL2)
                datavalues = [G1,G2,valueK1,valueK2,0,0,K1,K2,0,0]
                qt.msleep(0.01)
            
            elif Nlockins == 1:
                qt.msleep(delay2)                                                       # Use explained at bottom of the script
                K1 = keithley1.get_readnextval()                                        # Read out Keithley1
                K2 = keithley2.get_readnextval()                                        # Read out Keithley2
                XL1 = lockin1.get_X()                                                   # Read out R Lockin1
                YL1 = lockin1.get_Y()                                               # Read out theta Lockin1

                valueK1 = K1/GainK1                                                   # Process data Keithley1
                valueK2 = K2/GainK2                                                     # Process data Keithley2
                valueL1 = (XL1/GainL1)/(amplitude1/sqrt(2)-(XL1/GainL1)*RsL1)                # Process data Lockin1
                if dacx == 'dac1':
                    G = valueK1/(x*Vrange*0.001-valueK1*RsL1)
                else:
                    G = valueK1/(ivvi.get('dac1')*Vrange*0.001-valueK1*RsL1)
                datavalues = [valueK1,valueK2,valueL1,G,K1,K2,XL1,YL1,0,0]
                qt.msleep(0.01)
            
            elif Nlockins == 2:
                qt.msleep(delay2)                                                       # Use explained at bottom of the script
                K1 = keithley1.get_readnextval()                                        # Read out Keithley1
                K2 = keithley2.get_readnextval()                                        # Read out Keithley2
                XL1 = lockin1.get_X()                                                   # Read out X Lockin1
                YL1 = lockin1.get_Y()                                                   # Read out Y Lockin1
                XL2 = lockin2.get_X()                                                   # Read out X Lockin1
                YL2 = lockin2.get_Y()                                                   # Read out Y Lockin1
                RL2 = lockin2.get_R()                                                   # Read out X Lockin2
                thetaL2 = lockin2.get_P()                                                   # Read out Y Lockin2
                valueK1 = K1/GainK1                                                     # Process data Keithley1
                valueK2 = K2/GainK2                                                     # Process data Keithley2
                # LockinDataProcessingMode specifies 4 data processing modes for valueL1 and valueL2 (columns 6 and 7): 
                # 0: Voltage readout in current bias mode. 
                # 1: Conductance, both lock-in's measure the current under an applied bias voltage.
                # 2: Crossed Andreev reflection, Lock-in 1 measures the current (same as above) and Lock-in 2 measures the nonlocal voltage signal.
                # 3: Cooper pair splitter, both lock-in's measure the current flowing through each junction, with a Vsource applying a bias on the superconducting lead in the middle.
                if LockinDataProcessingMode == 0:
                    valueL1 = (XL1/GainL1)/(amplitude1/sqrt(2))  # R_xy (V_H/I_x)
                    valueL2 = (XL2/GainL2)/(amplitude2/sqrt(2))  # R_xx (V_xx/I_x)
                    #valueL1 = XL1/GainL1
                    #valueL2 = XL2/GainL2
                elif LockinDataProcessingMode == 1:
                    valueL1 = (XL1/GainL1)/(amplitude1/sqrt(2)-(XL1/GainL1)*RsL1)           # Process data Lockin1
                    valueL2 = (XL2/GainL2)/(amplitude2/sqrt(2)-(XL2/GainL2)*RsL2)           # Process data Lockin2
                elif LockinDataProcessingMode == 2:
                    valueL1 = (XL1/GainL1)/(amplitude1/sqrt(2)-(XL1/GainL1)*RsL1)           # Process data Lockin1
                    # valueL2 is the nonlocal voltage normalized by the local current magnitude
                    try:
                        valueL2 = XL2/(abs(XL1)+1e-6)       # adding a very small offset to prevent division by zero
                    except ZeroDivisionError:
                        valueL2 = float('Inf')              # this prevents the measurement being terminated if somehow the trick above doesn't work
                elif LockinDataProcessingMode == 3:
                    valueL1 = (XL1/GainL1) / (amplitude1/sqrt(2) - (XL1/GainL1)*(Rfilter1/2+Rin1_M1b) - (XL1/GainL1+XL2/GainL2)*Rfilter1/2)
                    valueL2 = (XL2/GainL2) / (amplitude2/sqrt(2) - (XL2/GainL2)*(Rfilter2/2+Rin2_M1b) - (XL1/GainL1+XL2/GainL2)*Rfilter1/2)
                else:
                    print 'LockinDataProcessingMode has to be 0, 1, 2, or 3 but is now ' + str(LockinDataProcessingMode)
                    print '0: current bias \n1: both lockins measure the conductance \n2: crossed Andreev reflection \n3: Cooper pair splitter'
                    print 'Please modify under the filename in the script'
                    qt.msleep(1.0)
                    sys.exit()

                datavalues = [valueK1,valueK2,valueL1,valueL2,K1,K2,XL1,YL1,RL2,thetaL2]
                qt.msleep(0.01)
            
        else:
            print 'You try to run a too complicated experiment...'
            qt.msleep(3.0)
            sys.exit()
        
        return datavalues
        qt.msleep(0.01)                                                              # Keep GUI responsive
    
        # Function reads out relevant data
        # added by onder 2015.05 in relation to 2dacs_vs_dac function
    def take_2data(self,dacx,dacx2,x):
        
        ivvi.set(dacx,x)                                                            # Set specified dac to specified value, has to be done here because of delays needed for Lockin measurements
        ivvi.set(dacx2,x)#line added by onder 
        
        if Nkeithleys == 0:
            
            if Nlockins == 0:
                print 'Why are you using this function if you dont want to read out any Keithley or Lockin...'
                qt.msleep(3.0)
                sys.exit()
            
            elif Nlockins == 1:
                qt.msleep(delay2)                                                       # Use explained at bottom of the script
                XL1 = lockin1.get_X()                                                   # Read out R Lockin1
                YL1 = lockin1.get_Y()                                               # Read out theta Lockin1
                valueL1 = (XL1/GainL1)/(amplitude1/sqrt(2)-(XL1/GainL1)*RsL1)           # Process data Lockin1
                datavalues = [0,0,valueL1,0,0,0,XL1,YL1,0,0]
                qt.msleep(0.01)
            
            elif Nlockins == 2:
                qt.msleep(delay2)                                                       # Use explained at bottom of the script
                XL1 = lockin1.get_X()                                                   # Read out Lockin1
                YL1 = lockin1.get_Y()                                               # Read out theta Lockin1
                XL2 = lockin2.get_X()                                                   # Read out Lockin2
                YL2 = lockin2.get_Y()                                               # Read out theta Lockin2
                valueL1 = (XL1/GainL1)/(amplitude1/sqrt(2)-(XL1/GainL1)*RsL1)           # Process data Lockin1
                valueL2 = (XL2/GainL2)/(amplitude2/sqrt(2)-(XL2/GainL2)*RsL2)           # Process data Lockin2
                datavalues = [0,0,valueL1,valueL2,0,0,XL1,YL1,XL2,YL2]
                qt.msleep(0.01)
        
        elif Nkeithleys == 1:
            
            if Nlockins == 0:
                K1 = keithley1.get_readnextval()                                        # Read out Keithley1            
                valueK1 = K1/GainK1                                                     # Process data Keithley1
                datavalues = [0,0,valueK1,0,0,0,K1,0,0,0]
                qt.msleep(0.01)
            
            elif Nlockins == 1:
                qt.msleep(delay2)                                                       # Use explained at bottom of the script
                K1 = keithley1.get_readlastval()                                        # Read out Keithley1
                XL1 = lockin1.get_X()                                                   # Read out R Lockin1
                YL1 = lockin1.get_Y()                                               # Read out theta Lockin1
                valueK1 = K1/GainK1                                                     # Process data Keithley1
                valueL1 = (XL1/GainL1)/(amplitude1/sqrt(2)-(XL1/GainL1)*RsL1)           # Process data Lockin1
                datavalues = [valueK1,0,valueL1,0,K1,0,XL1,YL1,0,0]
                qt.msleep(0.01)
            
            elif Nlockins == 2:
                qt.msleep(delay2)                                                       # Use explained at bottom of the script
                K1 = keithley1.get_readnextval()                                        # Read out Keithley1
                XL1 = lockin1.get_X()                                                   # Read out Lockin1
                YL1 = lockin1.get_Y()                                               # Read out theta Lockin1
                XL2 = lockin2.get_X()                                                   # Read out Lockin2
                YL2 = lockin2.get_Y()                                               # Read out theta Lockin2
                valueK1 = K1/GainK1                                                     # Process data Keithley1
                valueL1 = (XL1/GainL1)/(amplitude1/sqrt(2)-(XL1/GainL1)*RsL1)           # Process data Lockin1
                valueL2 = (XL2/GainL2)/(amplitude2/sqrt(2)-(XL2/GainL2)*RsL2)           # Process data Lockin2value = (L1/GainL1)*(GainL2/L2)                                      # Process the data
                datavalues = [valueK1,0,valueL1,valueL2,K1,0,XL1,YL1,XL2,YL2]
                qt.msleep(0.01)
            
        elif Nkeithleys == 2:
            
            if Nlockins == 0:
                K1 = keithley1.get_readnextval()                                        # Read out Keithley1
                K2 = keithley2.get_readnextval()                                        # Read out Keithley2
                valueK1 = K1/GainK1                                                     # Process data Keithley1
                valueK2 = K2/GainK2                                                     # Process data Keithley2
                if dacx == 'dac1':
                    G1 = valueK1/(x*Vrange*0.001-valueK1*RsL1)
                    G2 = valueK2/(x*Vrange*0.001-valueK2*RsL2)
                else: 
                    G1 = valueK1/(ivvi.get('dac1')*Vrange*0.001-valueK1*RsL1)
                    G2 = valueK2/(ivvi.get('dac1')*Vrange*0.001-valueK2*RsL2)
                datavalues = [G1,G2,valueK1,valueK2,0,0,K1,K2,0,0]
                qt.msleep(0.01)
            
            elif Nlockins == 1:
                qt.msleep(delay2)                                                       # Use explained at bottom of the script
                K1 = keithley1.get_readnextval()                                        # Read out Keithley1
                K2 = keithley2.get_readnextval()                                        # Read out Keithley2
                XL1 = lockin1.get_X()                                                   # Read out R Lockin1
                YL1 = lockin1.get_Y()                                               # Read out theta Lockin1
                valueK1 = K1/GainK1                                                   # Process data Keithley1
                valueK2 = K2/GainK2                                                     # Process data Keithley2
                valueL1 = (XL1/GainL1)/(amplitude1/sqrt(2)-(XL1/GainL1)*RsL1)                # Process data Lockin1
                if dacx == 'dac1':
                    G = valueK1/(x*Vrange*0.001-valueK1*RsL1)
                else:
                    G = valueK1/(ivvi.get('dac1')*Vrange*0.001-valueK1*RsL1)
                datavalues = [valueK1,valueK2,valueL1,G,K1,K2,XL1,YL1,0,0]
                qt.msleep(0.01)
            
            elif Nlockins == 2:
                qt.msleep(delay2)                                                       # Use explained at bottom of the script
                K1 = keithley1.get_readnextval()                                        # Read out Keithley1
                K2 = keithley2.get_readnextval()                                        # Read out Keithley2
                XL1 = lockin1.get_X()
                YL1 = lockin1.get_Y()
                XL2 = lockin2.get_X()
                YL2 = lockin2.get_Y()
                valueK1 = K1/GainK1                                                     # Process data Keithley1
                valueK2 = K2/GainK2                                                     # Process data Keithley2
                valueL1 = (XL1/GainL1)/(amplitude1/sqrt(2)-(XL1/GainL1)*RsL1)           # Process data Lockin1
                valueL2 = (XL2/GainL2)/(amplitude2/sqrt(2)-(XL2/GainL2)*RsL2)           # Process data Lockin2
                datavalues = [valueK1,valueK2,valueL1,valueL2,K1,K2,XL1,YL1,XL2,YL2]
                qt.msleep(0.01)
            
        else:
            print 'You try to run a too complicated experiment...'
            qt.msleep(3.0)
            sys.exit()
        
        return datavalues
        qt.msleep(0.01)                                                              # Keep GUI responsive
    
    
    
    
    # Function to control bias switch between different lead biasing
    def bias_switch(self,switch_bias,side1,side2,biasdac,controldac):
        
        if switch_bias == 'ON':
            
            if switch_bias_mode == 'FLOATING':
            
                if side1 == 'ON':
                    
                    if side2 == 'ON':
                        
                        print 'bias switching doesnt work with lead1 and lead2 both "ON", error in script!!!'
                        sys.exit()
                    
                    elif side2 == 'OFF':
                        
                        control_lead = ivvi.get(controldac)
                        ivvi.set(biasdac,0.0)
                        
                        if control_lead > 1495.0:

                                return
                            
                        else:    
                            
                            ivvi.set(biasdac,0.0)
                            ivvi.set(controldac,1500.0)
                            qt.msleep(5.0)
                    
                    else:
                        
                        print 'typo in value lead2'
                        sys.exit()
                
                elif side2 == 'ON':
                    
                    if side1 == 'OFF':
                        
                        control_lead = ivvi.get(controldac)
                        ivvi.set(biasdac,0.0)
                        
                        if control_lead < -1495.0:
                        
                           return
                            
                        else:
                        
                            ivvi.set(biasdac,0.0)
                            ivvi.set(controldac,-1500.0)
                            qt.msleep(5.0)
                    
                    else:
                        
                        print 'typo in value lead1'
                        sys.exit()
                else:
                    
                    print 'typo in value lead1 and/or value lead2'
                    sys.exit()
                  
            elif switch_bias_mode == 'TWOTERMINAL':                 #### This function is kept the same as it was before
                
                if lead1 == 'ON':
                    
                    if lead2 == 'ON':
                        
                        print 'bias switching doesnt work with lead1 and lead2 both "ON", error in script!!!'
                        sys.exit()
                    
                    elif lead2 == 'OFF':
                        
                        control_lead1 = ivvi.get(controldac_lead1)
                        control_lead2 = ivvi.get(controldac_lead2)
                        
                        if control_lead1 > 1495.0:
                            
                            if control_lead2 < -1495.0:
                                return
                            
                        else:    
                            
                            ivvi.set(biasdac_lead1,0.0)
                            ivvi.set(biasdac_lead2,0.0)
                            ivvi.set(controldac_lead1,1500.0)
                            ivvi.set(controldac_lead2,-1500.0)
                            qt.msleep(5.0)
                    
                    else:
                        
                        print 'typo in value lead2'
                        sys.exit()
                
                elif lead2 == 'ON':
                    
                    if lead1 == 'OFF':
                        
                        control_lead1 = ivvi.get(controldac_lead1)
                        control_lead2 = ivvi.get(controldac_lead2)
                        
                        if control_lead1 < -1495.0:
                        
                            if control_lead2 > 1495:
                                return
                            
                        else:
                        
                            ivvi.set(biasdac_lead1,0.0)
                            ivvi.set(biasdac_lead2,0.0)
                            ivvi.set(controldac_lead1,-1500.0)
                            ivvi.set(controldac_lead2,1500.0)
                            qt.msleep(5.0)
                    
                    else:
                        
                        print 'typo in value lead1'
                        sys.exit()
                else:
                    
                    print 'typo in value lead1 and/or value lead2'
                    sys.exit()
                     
            else:
            
                print 'typo in value switch_bias_mode'
                sys.exit()
                
        else:
            return
            
            
    # Function to read out 1K pot temperature
    def read_T_1kpot(self):
        return lakeshore.get_kelvinB()
    
    # Function to read out tail temperature
    def read_T(self):
        return 0
        #return lakeshore.get_kelvinC()    
    
    # Function to set B value
    def set_B(self,B):
    
        if magnet == 'kepco':
            kepco.set_B(B)
        
        elif magnet == 'OxfordMK3':
            OxfordMK3.set_B(B)
        
        elif magnet == 'Cryomagnetics_4G':
            B_in_T = B
            B_in_kG = B_in_T*10
            Cryomagnetics_4G.set_fieldZ(B_in_kG)
            while True:
                qt.msleep(0.02)
                if abs(Cryomagnetics_4G.get_fieldZ() - B_in_kG) < 0.02:
                    return
                
        elif magnet == 'Cryomagnetics_4G_X':
            B_in_T = B
            B_in_kG = B_in_T*10
            Cryomagnetics_4G.set_fieldX(B_in_kG)
            while True:
                qt.msleep(0.02)
                if abs(Cryomagnetics_4G.get_fieldX() - B_in_kG) < 0.02:
                    return
                
        
        elif magnet == 'OxfordMK3nodriver':
        
            if B < 0:
                print 'Power supply unipolar, cannot set negative field'
                return
                
            elif B > Bmax:
                print 'Danger of magnet quench: B_set = ' + `B` + ' > B_max = ' + `Bmax`
                return    
                
            else:
                #coilConstant = 0.0678 #Tesla per Amp
                #IVconstant = #magnet current in amps per output voltage
                TVconstant = 2.8/(-3.47)#Tesla per Volt
                lockinIncrement = 0.001# = 1mV = resolution of aux output
                rampRate = 0.05 # Tesla per min
                currentLockin = lockin3.read_aux(1)#in volts
                #print 'currentLockin'
                #print currentLockin
                currentField = currentLockin*TVconstant #conversion to Tesla
                print 'currentField'
                print currentField
                print 'setField'
                print B
                rampDistanceB = B - currentField #in Tesla
                #print 'rampDistanceB'
                #print rampDistanceB
                rampDistanceLockin = rampDistanceB/TVconstant #in Volts
                #print 'rampDistanceLockin'
                #print rampDistanceLockin
                rampTime = abs((rampDistanceB/rampRate) * 60.0) #in second.
                #print 'rampTime'
                #print rampTime
                intRampIterationMax = int(math.floor(abs(rampDistanceLockin) / lockinIncrement))
                #print 'intRampIterationMax'
                #print intRampIterationMax
                if intRampIterationMax > 0:
                    waitTime = abs(rampTime / intRampIterationMax)
                    #print 'waitTime'
                    #print waitTime            
                    if rampDistanceB > 0:
                        lockinIncrement = - lockinIncrement
                    #print 'lockinIncrement'
                    #print lockinIncrement 
                    for i in range(1,intRampIterationMax+1):
                        lockin3.set_aux(1,i*lockinIncrement + currentLockin)
                        qt.msleep(waitTime)
                        #print i*lockinIncrement + currentLockin
                
        elif magnet == 'AMI430':
            AMI430.set_field(B)

        elif magnet=='cryomag':
            B_in_T = B
            B_in_mT = B_in_T*1000
            cryomag.set_field(B_in_mT)
            while abs(cryomag.get_field() - B_in_mT) > 10:
                qt.msleep(0.02)
    
    ################ 1D SCANS #####################    
    
    
    # 1D sweep of a single dac
    def _single_dac_sweep(self,xname,dacx,xstart,xend,xsteps):
        qt.mstart()
        
        # Create sweep vectors
        x_vector = linspace(xstart,xend,xsteps+1)
        y_vector = [0]
        z_vector = [0]
        
        data = self.create_data(x_vector,xname,dacx,y_vector,'none','y_parameter',z_vector,'none','z_parameter')                                # create data file, spyview metafile, copy script
        
        ivvi.set(dacx,x_vector[0])
        qt.msleep(delay1)
        
        for x in x_vector:
            datavalues = self.take_data(dacx,x)                                                                                                 # Go to next sweep value and take data
            T_mc = self.read_T()                                                                                                                # Read out mixing chamber temperature
            data.add_data_point(x,0,0,datavalues[0],datavalues[1],datavalues[2],datavalues[3],datavalues[4],datavalues[5],datavalues[6],datavalues[7],datavalues[8],datavalues[9],T_mc)                               # write datapoint into datafile
        
        data.new_block()
        data._write_settings_file()                                                                                                             # Overwrite the settings file created at the beginning, this ensures updating the sweep variable with the latest value
        data.close_file()
        qt.mend()
    
    
    # Repeatedly sweep a single dac n times, n = repetions
    def _repeat_single_dac_sweep(self,xname,dacx,xstart,xend,xsteps,repetions):
        qt.mstart()
        
        # Create sweep vectors
        x_vector = linspace(xstart,xend,xsteps+1)
        y_vector = linspace(1,repetions,repetions)                                                                                              # this sweep variable is defined to enable 2D plotting in spyview
        z_vector = [0]
        
        data = self.create_data(x_vector,xname,dacx,y_vector,'n','repetions',z_vector,'none','z_parameter')                                     # create data file, spyview metafile, copy script
        
        counter = 0
        
        for i in arange(repetions):
            [starttime, counter] = timetrack.start(counter)
            tstart = timetrack.time()
            ivvi.set(dacx,x_vector[0])
            T_mc = self.read_T()                                                                                                                # Read out mixing chamber temperature
            qt.msleep(delay1)                                                                                                                   # use explained at the bottom of the script
            
            for x in x_vector:
                datavalues = self.take_data(dacx,x)                                                                                             # Go to next sweep value and take data
                data.add_data_point(x,0,0,datavalues[0],datavalues[1],datavalues[2],datavalues[3],datavalues[4],datavalues[5],datavalues[6],datavalues[7],datavalues[8],datavalues[9],T_mc)                           # write datapoint into datafile
            
            timetrack.remainingtime(starttime,repetions,counter)                                                                                # Calculate and print remaining scantime
            data.new_block()
            
        data._write_settings_file()                                                                                                             # Overwrite the settings file created at the beginning, this ensures updating the sweep variable with the latest value
        data.close_file()
        qt.mend()    
    
    # 1D sweep of 2 dac's simultaneously; sweep vectors can have arbitrary start and end values.
    def _2dacs_sweep(self,xname,dacx,xstart,xend,mname,dacm,mstart,mend,steps):
        qt.mstart()
                
        # Create sweep vectors
        x_vector = linspace(xstart,xend,steps+1)
        y_vector = [0]
        z_vector = [0]
        
        data = self.create_data(x_vector,xname,dacx,y_vector,'none','y_parameter',z_vector,'none','z_parameter')                               # create data file, spyview metafile, copy script
        
        # Define sweep vector for other dac
        m_vector = linspace(mstart,mend,steps+1)
        
        for i in arange(len(x_vector)):
            x = x_vector[i]
            m = m_vector[i]
            ivvi.set(dacm,m)                                                                                                                    # Other dac needs to be set before running take_data
            datavalues = self.take_data(dacx,x)                                                                                                 # Go to next sweep value and take data
            T_mc = self.read_T()                                                                                                                # Read out mixing chamber temperature
            data.add_data_point(x,0,0,datavalues[0],datavalues[1],datavalues[2],datavalues[3],datavalues[4],datavalues[5],datavalues[6],datavalues[7],datavalues[8],datavalues[9],T_mc)                               # write datapoint into datafile
        
        data.new_block()
        data._write_settings_file()
        data.close_file()
        qt.mend()

    # 1D sweep of 3 dac's simultaneously; sweep vectors can have arbitrary start and end values.
    def _3dacs_sweep(self,xname,dacx,xstart,xend,mname,dacm,mstart,mend,nname,dacn,nstart,nend,steps):
        qt.mstart()
        
        # Create sweep vectors
        x_vector = linspace(xstart,xend,steps+1)
        y_vector = [0]
        z_vector = [0]
        
        data = self.create_data(x_vector,xname,dacx,y_vector,'none','y_parameter',z_vector,'none','z_parameter')                               # create data file, spyview metafile, copy script
        
        # Define sweep vector for other dacs
        m_vector = linspace(mstart,mend,steps+1)
        n_vector = linspace(nstart,nend,steps+1)
        
        for i in arange(len(x_vector)):
            x = x_vector[i]
            m = m_vector[i]
            n = n_vector[i]
            ivvi.set(dacm,m)                                                                                                                    # Other dacs needs to be set before running take_data
            ivvi.set(dacn,n)
            datavalues = self.take_data(dacx,x)                                                                                                 # Go to next sweep value and take data
            T_mc = self.read_T()                                                                                                                # Read out mixing chamber temperature
            data.add_data_point(x,0,0,datavalues[0],datavalues[1],datavalues[2],datavalues[3],datavalues[4],datavalues[5],datavalues[6],datavalues[7],datavalues[8],datavalues[9],T_mc)                               # write datapoint into datafile
        
        data.new_block()
        data._write_settings_file()
        data.close_file()
        qt.mend()
        
    # 1D sweep of 4 dac's simultaneously; sweep vectors can have arbitrary start and end values.
    def _4dacs_sweep(self,xname,dacx,xstart,xend,mname,dacm,mstart,mend,nname,dacn,nstart,nend,pname,dacp,pstart,pend,steps):
        qt.mstart()
        
        # Create sweep vectors
        x_vector = linspace(xstart,xend,steps+1)
        y_vector = [0]
        z_vector = [0]
        
        data = self.create_data(x_vector,xname,dacx,y_vector,'none','y_parameter',z_vector,'none','z_parameter')                               # create data file, spyview metafile, copy script
        
        # Define sweep vector for other dacs
        m_vector = linspace(mstart,mend,steps+1)
        n_vector = linspace(nstart,nend,steps+1)
        p_vector = linspace(pstart,pend,steps+1)
        
        for i in arange(len(x_vector)):
            x = x_vector[i]
            m = m_vector[i]
            n = n_vector[i]
            p = p_vector[i]
            ivvi.set(dacm,m)                                                                                                                    # Other dacs needs to be set before running take_data
            ivvi.set(dacn,n)
            ivvi.set(dacp,p)
            datavalues = self.take_data(dacx,x)                                                                                                 # Go to next sweep value and take data
            T_mc = self.read_T()                                                                                                                # Read out mixing chamber temperature
            data.add_data_point(x,0,0,datavalues[0],datavalues[1],datavalues[2],datavalues[3],datavalues[4],datavalues[5],datavalues[6],datavalues[7],datavalues[8],datavalues[9],T_mc)                               # write datapoint into datafile
        
        data.new_block()
        data._write_settings_file()
        data.close_file()
        qt.mend()
    
        # 1D sweep of 11 dacs, all together, same range
   
    def _11_dacs_sweep(self,xname,dacx,yname,dacy,zname,dacz,kname,dack,lname,dacl,mname,dacm,nname,dacn,oname,daco,pname,dacp,qname,dacq,rname,dacr,xstart,xend,xsteps):
        qt.mstart()
        
        # Create sweep vectors
        x_vector = linspace(xstart,xend,xsteps+1)
        y_vector = [0]
        z_vector = [0]
        
        data = self.create_data(x_vector,xname,dacx,y_vector,'none','y_parameter',z_vector,'none','z_parameter')                                # create data file, spyview metafile, copy script
        
        for x in x_vector:
            ivvi.set(dacy,x)
            ivvi.set(dacz,x)
            ivvi.set(dack,x)
            ivvi.set(dacl,x)
            ivvi.set(dacm,x)
            ivvi.set(dacn,x)
            ivvi.set(daco,x)
            ivvi.set(dacp,x)
            ivvi.set(dacq,x)
            ivvi.set(dacr,x)
            datavalues = self.take_data(dacx,x)                                                                                                 # Go to next sweep value and take data
            T_mc = self.read_T()                                                                                                                # Read out mixing chamber temperature
            data.add_data_point(x,0,0,datavalues[0],datavalues[1],datavalues[2],datavalues[3],datavalues[4],datavalues[5],datavalues[6],datavalues[7],datavalues[8],datavalues[9],T_mc)                               # write datapoint into datafile
        
        data.new_block()
        data._write_settings_file()                                                                                                             # Overwrite the settings file created at the beginning, this ensures updating the sweep variable with the latest value
        data.close_file()
        qt.mend()
    
    
    # monitoring the current at a given bias during cool down/warm up
    def _time_sweep(self, time_steps, time_interval):
        qt.mstart()

        # Create sweep vectors
        x_vector = linspace(0, time_interval*time_steps, time_steps+1) # time interval in seconds
        y_vector = [0]
        z_vector = [0]

        data = self.create_data(x_vector,"seconds",'time',y_vector,'none','y_parameter',z_vector,'none','z_parameter')  # create data file, spyview metafile, copy script

        qt.msleep(delay1)
        t0 = time.time()
        
        for i,x in enumerate(x_vector):
            K1 = keithley1.get_readnextval()
            K2 = keithley2.get_readnextval()
            datavalues = [0,0,K1/GainK1,K2/GainK2,0,0,K1,K2,0,0]  # Go to next sweep value and take data
            #T_mc = self.read_T() # Read out temperature
            T_1kpot = self.read_T_1kpot() # read out 1K pot temperature (during cool down tail temp sensor is out of range, so we use this one to monitor the temperature)
            data.add_data_point(x,0,0,datavalues[0],datavalues[1],datavalues[2],datavalues[3],datavalues[4],datavalues[5],datavalues[6],datavalues[7],datavalues[8],datavalues[9],T_1kpot)           # write datapoint into datafile
            t = time.time()
            trem = (t-t0)/(i+1)*(time_steps+1-(i+1))
            trem = str(timedelta(seconds=trem))[:-7]
            print 'Measuring {:s} sweep from {:.5g} to {:.5g} - {:.5g} - {:s} remaining          \r'.format("time",0,time_interval*time_steps,x,trem),
            qt.msleep(time_interval)
            
        data.new_block()
        data._write_settings_file()                                                                                                             # Overwrite the settings file created at the beginning, this ensures updating the sweep variable with the latest value
        data.close_file()
        qt.mend()
    


    #################### 2D SCANS ####################
    
    
    # 2D scan of one dac vs another one
    def _dac_vs_dac(self,xname,dacx,xstart,xend,xsteps,yname,dacy,ystart,yend,ysteps):
        qt.mstart()
        
        # Create sweep vectors
        x_vector = linspace(xstart,xend,xsteps+1)
        y_vector = linspace(ystart,yend,ysteps+1)
        z_vector = [0]
        
        data = self.create_data(x_vector,xname,dacx,y_vector,yname,dacy,z_vector,'none','z_parameter')                                          # create data file, spyview metafile, copy script
        
        counter = 0
        
        for y in y_vector:
            [starttime, counter] = timetrack.start(counter)
            tstart = timetrack.time()
            ivvi.set(dacy,y)
            ivvi.set(dacx,x_vector[0])
            T_mc = self.read_T()                                                                                                                # Read out mixing chamber temperature 
            qt.msleep(delay1)                                                                                                                   # use explained at the bottom of the script
            
            for x in x_vector:
                datavalues = self.take_data(dacx,x)                                                                                             # Go to next sweep value and take data
                data.add_data_point(x,y,0,datavalues[0],datavalues[1],datavalues[2],datavalues[3],datavalues[4],datavalues[5],datavalues[6],datavalues[7],datavalues[8],datavalues[9],T_mc)                           # write datapoint into datafile
            
            timetrack.remainingtime(starttime,ysteps+1,counter)                                                                                 # Calculate and print remaining scantime
            data.new_block()
            
        data._write_settings_file()                                                                                                             # Overwrite the settings file created at the beginning, this ensures updating the sweep variable with the latest value
        data.close_file()
        qt.mend()
    
        # added by onder 2015.05
        # 2D scan of 2 dacs vs another one
        # swept dac values (dacx and dacx2) are the same!
    def _2dacs_vs_dac(self,xname,dacx,dacx2,xstart,xend,xsteps,yname,dacy,ystart,yend,ysteps):
        qt.mstart()
        
        # Create sweep vectors
        x_vector = linspace(xstart,xend,xsteps+1)
        y_vector = linspace(ystart,yend,ysteps+1)
        z_vector = [0]
        
        data = self.create_data(x_vector,xname,dacx,y_vector,yname,dacy,z_vector,'none','z_parameter')                                          # create data file, spyview metafile, copy script
        
        counter = 0
        
        for y in y_vector:
            [starttime, counter] = timetrack.start(counter)
            tstart = timetrack.time()
            ivvi.set(dacy,y)
            ivvi.set(dacx,x_vector[0])
            ivvi.set(dacx2,x_vector[0])#line modified by onder  
            T_mc = self.read_T()                                                                                                                # Read out mixing chamber temperature 
            qt.msleep(delay1)                                                                                                                   # use explained at the bottom of the script
            
            for x in x_vector:
                datavalues = self.take_2data(dacx,dacx2,x)#line modified by onder                                                                                             # Go to next sweep value and take data
                data.add_data_point(x,y,0,datavalues[0],datavalues[1],datavalues[2],datavalues[3],datavalues[4],datavalues[5],datavalues[6],datavalues[7],datavalues[8],datavalues[9],T_mc)                           # write datapoint into datafile
            
            timetrack.remainingtime(starttime,ysteps+1,counter)                                                                                 # Calculate and print remaining scantime
            data.new_block()
            
        data._write_settings_file()                                                                                                             # Overwrite the settings file created at the beginning, this ensures updating the sweep variable with the latest value
        data.close_file()
        qt.mend()
    
    # 2D scan of one dac vs 2 others; the 2 dacs that are stepped together can have arbitrary start and end values
    def _dac_vs_2dacs(self,xname,dacx,xstart,xend,xsteps,yname,dacy,ystart,yend,mname,dacm,mstart,mend,ymsteps):
        qt.mstart()
        
        # Create sweep vectors
        x_vector = linspace(xstart,xend,xsteps+1)
        y_vector = linspace(ystart,yend,ymsteps+1)
        z_vector = [0]
        
        data = self.create_data(x_vector,xname,dacx,y_vector,yname,dacy,z_vector,'none','z_parameter')                                          # create data file, spyview metafile, copy script
        
        # Define sweep vector for other dac
        m_vector = linspace(mstart,mend,ymsteps+1)
        
        counter = 0
        
        for i in arange(len(y_vector)):
            [starttime, counter] = timetrack.start(counter)
            tstart = timetrack.time()
            y = y_vector[i]
            m = m_vector[i]
            ivvi.set(dacy,y)
            ivvi.set(dacm,m)
            ivvi.set(dacx,x_vector[0])
            T_mc = self.read_T()                                                                                                                # Read out mixing chamber temperature 
            qt.msleep(delay1)                                                                                                                   # use explained at the bottom of the script
            
            for x in x_vector:
                datavalues = self.take_data(dacx,x)                                                                                             # Go to next sweep value and take data
                data.add_data_point(x,y,0,datavalues[0],datavalues[1],datavalues[2],datavalues[3],datavalues[4],datavalues[5],datavalues[6],datavalues[7],datavalues[8],datavalues[9],T_mc)                           # write datapoint into datafile
            
            timetrack.remainingtime(starttime,ymsteps+1,counter)                                                                                # Calculate and print remaining scantime
            data.new_block()
            
        data._write_settings_file()                                                                                                             # Overwrite the settings file created at the beginning, this ensures updating the sweep variable with the latest value
        data.close_file()
        qt.mend()
    
    
    # 2D scan of one dac vs 3 others; the 3 dacs that are stepped together can have arbitrary start and end values
    def _dac_vs_3dacs(self,xname,dacx,xstart,xend,xsteps,yname,dacy,ystart,yend,mname,dacm,mstart,mend,nname,dacn,nstart,nend,ymnsteps):
        qt.mstart()
        
        # Create sweep vectors
        x_vector = linspace(xstart,xend,xsteps+1)
        y_vector = linspace(ystart,yend,ymnsteps+1)
        z_vector = [0]
        
        data = self.create_data(x_vector,xname,dacx,y_vector,yname,dacy,z_vector,'none','z_parameter')                                          # create data file, spyview metafile, copy script
        
        # Define sweep vector for other dacs
        m_vector = linspace(mstart,mend,ymnsteps+1)
        n_vector = linspace(nstart,nend,ymnsteps+1)
        
        counter = 0
        
        for i in arange(len(y_vector)):
            [starttime, counter] = timetrack.start(counter)
            tstart = timetrack.time()
            y = y_vector[i]
            m = m_vector[i]
            n = n_vector[i]
            ivvi.set(dacy,y)
            ivvi.set(dacm,m)
            ivvi.set(dacn,n)
            ivvi.set(dacx,x_vector[0])
            T_mc = self.read_T()                                                                                                                # Read out mixing chamber temperature 
            qt.msleep(delay1)                                                                                                                   # use explained at the bottom of the script
            
            for x in x_vector:
                datavalues = self.take_data(dacx,x)                                                                                             # Go to next sweep value and take data
                data.add_data_point(x,y,0,datavalues[0],datavalues[1],datavalues[2],datavalues[3],datavalues[4],datavalues[5],datavalues[6],datavalues[7],datavalues[8],datavalues[9],T_mc)                           # write datapoint into datafile
            
            timetrack.remainingtime(starttime,ymnsteps+1,counter)                                                                               # Calculate and print remaining scantime
            data.new_block()
            
        data._write_settings_file()                                                                                                             # Overwrite the settings file created at the beginning, this ensures updating the sweep variable with the latest value
        data.close_file()
        qt.mend()
    
    
    # 2D scan of one dac vs 4 others; the 4 dacs that are stepped together can have arbitrary start and end values
    def _dac_vs_4dacs(self,xname,dacx,xstart,xend,xsteps,yname,dacy,ystart,yend,mname,dacm,mstart,mend,nname,dacn,nstart,nend,pname,dacp,pstart,pend,ymnpsteps):
        qt.mstart()
        
        # Create sweep vectors
        x_vector = linspace(xstart,xend,xsteps+1)
        y_vector = linspace(ystart,yend,ymnpsteps+1)
        z_vector = [0]
        
        data = self.create_data(x_vector,xname,dacx,y_vector,yname,dacy,z_vector,'none','z_parameter')                                          # create data file, spyview metafile, copy script
        
        # Define sweep vector for other dacs
        m_vector = linspace(mstart,mend,ymnpsteps+1)
        n_vector = linspace(nstart,nend,ymnpsteps+1)
        p_vector = linspace(pstart,pend,ymnpsteps+1)
        
        counter = 0
        
        for i in arange(len(y_vector)):
            [starttime, counter] = timetrack.start(counter)
            tstart = timetrack.time()
            y = y_vector[i]
            m = m_vector[i]
            n = n_vector[i]
            p = p_vector[i]
            ivvi.set(dacy,y)
            ivvi.set(dacm,m)
            ivvi.set(dacn,n)
            ivvi.set(dacp,p)
            ivvi.set(dacx,x_vector[0])
            T_mc = self.read_T()                                                                                                                # Read out mixing chamber temperature
            qt.msleep(delay1)                                                                                                                   # use explained at the bottom of the script
            
            for x in x_vector:
                datavalues = self.take_data(dacx,x)                                                                                             # Go to next sweep value and take data
                data.add_data_point(x,y,0,datavalues[0],datavalues[1],datavalues[2],datavalues[3],datavalues[4],datavalues[5],datavalues[6],datavalues[7],datavalues[8],datavalues[9],T_mc)                           # write datapoint into datafile
            
            timetrack.remainingtime(starttime,ymnpsteps+1,counter)                                                                              # Calculate and print remaining scantime
            data.new_block()
            
        data._write_settings_file()                                                                                                             # Overwrite the settings file created at the beginning, this ensures updating the sweep variable with the latest value
        data.close_file()
        qt.mend()
        
    
    # 2D scan of one dac vs another one n times repeated, n = repetions
    def _repeat_dac_vs_dac(self,xname,dacx,xstart,xend,xsteps,yname,dacy,ystart,yend,ysteps,repetions):
        qt.mstart()
        
        # Create sweep vectors
        x_vector = linspace(xstart,xend,xsteps+1)
        y_vector = linspace(ystart,yend,ysteps+1)
        z_vector = linspace(1,repetions,repetions)
        
        data = self.create_data(x_vector,xname,dacx,y_vector,yname,dacy,z_vector,'n','repetions')                                               # create data file, spyview metafile, copy script
        
        counter = 0
        numloops = repetions*(ysteps+1)
        
        for i in arange(repetions):
            ivvi.set(dacy,y[0])
            ivvi.set(dacx,x[0])
           
            for y in y_vector:
                [starttime, counter] = timetrack.start(counter)
                tstart = timetrack.time()
                ivvi.set(dacy,y)
                ivvi.set(dacx,x[0])
                T_mc = self.read_T()                                                                                                            # Read out mixing chamber temperature 
                qt.msleep(delay1)                                                                                                               # use explained at the bottom of the script
            
                for x in x_vector:
                    datavalues = self.take_data(dacx,x)                                                                                         # Go to next sweep value and take data
                    data.add_data_point(x,y,0,datavalues[0],datavalues[1],datavalues[2],datavalues[3],datavalues[4],datavalues[5],datavalues[6],datavalues[7],datavalues[8],datavalues[9],T_mc)                       # write datapoint into datafile
            
                timetrack.remainingtime(starttime,numloops,counter)                                                                             # Calculate and print remaining scantime
                data.new_block()
            
        data._write_settings_file()                                                                                                             # Overwrite the settings file created at the beginning, this ensures updating the sweep variable with the latest value
        data.close_file()
        qt.mend()
        
    
    # 2D scan, every sweep consists of 2 times a dac sweep (first one from start to end of the sweep vector, 2nd one backwards from end to start of the sweep vector), this is done as a function of another dac.
    def _fwdbwd_dac_vs_dac(self,xname,dacx,xstart,xend,xsteps,yname,dacy,ystart,yend,ysteps):
        qt.mstart()
        
        # Create sweep vectors
        x_vector = linspace(xstart,xend,xsteps+1)
        y_vector = linspace(ystart,yend,ysteps+1)
        z_vector = [0]        
        
        data_fwd = self.create_data(x_vector,xname,dacx,y_vector,yname,dacy,z_vector,'none','z_parameter')                                      # create data file, spyview metafile, copy script for fwd sweep direction
        x_vector = x_vector[::-1]                                                                                                               # reverse direction of sweep vector to ensure proper spyview metafile
        data_bwd = self.create_data(x_vector,xname,dacx,y_vector,yname,dacy,z_vector,'none','z_parameter')                                      # create data file, spyview metafile, copy script for bwd sweep direction
        x_vector = x_vector[::-1]                                                                                                               # reverse direction sweep vector back to original
        
        
        counter = 0
                
        for y in y_vector:
            [starttime, counter] = timetrack.start(counter)
            tstart=timetrack.time();
            ivvi.set(y_parameter,y)
            
            
            for data_loop in (data_fwd, data_bwd):
                
                ivvi.set(dacx,x_vector[0])
                T_mc = self.read_T()                                                                                                                # Read out mixing chamber temperature
                qt.msleep(delay1)
                
                for x in x_vector:
                    datavalues = self.take_data(dacx,x)                                                                                             # Go to next sweep value and take data
                    data_loop.add_data_point(x,y,0,datavalues[0],datavalues[1],datavalues[2],datavalues[3],datavalues[4],datavalues[5],datavalues[6],datavalues[7],datavalues[8],datavalues[9],T_mc)                      # write datapoint into datafile
                    
                data_loop.new_block()
                
                # Toggle forward / backward by reversing vector
                x_vector = x_vector[::-1]
            
            tstop = timetrack.time()
            timetrack.remainingtime(starttime,ysteps+1,counter)                                                                                 # Calculate and print remaining scantime
            
        for data_loop in (data_fwd, data_bwd):
            data_loop._write_settings_file()                                                                                                    # Overwrite the settings file created at the beginning, this ensures updating the sweep variable with the latest value
            data_loop.close_file()
            
        qt.mend()

        
    ############### 3D scans ########################
    
    # 3D scan of one dac vs another dac vs another dac
    def _dac_vs_dac_vs_dac(self,xname,dacx,xstart,xend,xsteps,yname,dacy,ystart,yend,ysteps,zname,dacz,zstart,zend,zsteps):
        qt.mstart()
        
        # Create sweep vectors
        x_vector = linspace(xstart,xend,xsteps+1)
        y_vector = linspace(ystart,yend,ysteps+1)
        z_vector = linspace(zstart,zend,zsteps+1)
        
        data = self.create_data(x_vector,xname,dacx,y_vector,yname,dacy,z_vector,zname,dacz)                                                    # create data file, spyview metafile, copy script
        
        counter = 0
        numloops = (zsteps+1)*(ysteps+1)
        
        for z in z_vector:
            ivvi.set(dacz,z)
            
            for y in y_vector:
                [starttime, counter] = timetrack.start(counter)
                tstart = timetrack.time()
                ivvi.set(dacy,y)
                ivvi.set(dacx,x[0])
                T_mc = self.read_T()                                                                                                            # Read out mixing chamber temperature 
                qt.msleep(delay1)                                                                                                               # use explained at the bottom of the script
            
                for x in x_vector:
                    datavalues = self.take_data(dacx,x)                                                                                         # Go to next sweep value and take data
                    data.add_data_point(x,y,z,datavalues[0],datavalues[1],datavalues[2],datavalues[3],datavalues[4],datavalues[5],datavalues[6],datavalues[7],datavalues[8],datavalues[9],T_mc)                       # write datapoint into datafile
            
                timetrack.remainingtime(starttime,numloops,counter)                                                                             # Calculate and print remaining scantime
                data.new_block()
            
        data._write_settings_file()                                                                                                             # Overwrite the settings file created at the beginning, this ensures updating the sweep variable with the latest value
        data.close_file()
        qt.mend()

        
    ############### SCANS INVOLVING OTHER EQUIPMENT (MAGNET SUPPLY, RF SOURCE) #################
    
    
    # To scan a dac as a function of B
    def _dac_vs_magnet(self,xname,dacx,xstart,xend,xsteps,Bstart,Bend,Bsteps):
        qt.mstart()
        
        # Create sweep vectors
        x_vector = linspace(xstart,xend,xsteps+1)
        B_vector = linspace(Bstart,Bend,Bsteps+1)
        z_vector = [0]
        
        data = self.create_data(x_vector,xname,dacx,B_vector,'B (T)',magnet,z_vector,'none','z_parameter')                                      # create data file, spyview metafile, copy script
        
        counter = 0
        
        for B in B_vector:
            [starttime, counter] = timetrack.start(counter)
            tstart = timetrack.time()
            self.set_B(B)                                                                                                                       # Sets B field
            ivvi.set(dacx,x_vector[0])
            T_mc = self.read_T()                                                                                                                # Read out mixing chamber temperature 
            qt.msleep(delay1)                                                                                                                   # use explained at the bottom of the script
            
            for x in x_vector:
                datavalues = self.take_data(dacx,x)                                                                                             # Go to next sweep value and take data
                data.add_data_point(x,B,0,datavalues[0],datavalues[1],datavalues[2],datavalues[3],datavalues[4],datavalues[5],datavalues[6],datavalues[7],datavalues[8],datavalues[9],T_mc)                           # write datapoint into datafile
            
            timetrack.remainingtime(starttime,Bsteps+1,counter)                                                                                 # Calculate and print remaining scantime
            data.new_block()
            
        data._write_settings_file()                                                                                                             # Overwrite the settings file created at the beginning, this ensures updating the sweep variable with the latest value
        data.close_file()
        qt.mend()

 
    # To scan a dac as a function of B
    # added by onder 2015.09
    # 2D scan of 2 dacs vs magnetic field
    # swept dac values (dacx and dacx2) are the same!
    def _2dac_vs_magnet(self,xname,dacx,dacx2,xstart,xend,xsteps,Bstart,Bend,Bsteps):
        qt.mstart()
        
        # Create sweep vectors
        x_vector = linspace(xstart,xend,xsteps+1)
        B_vector = linspace(Bstart,Bend,Bsteps+1)
        z_vector = [0]
        
        data = self.create_data(x_vector,xname,dacx,B_vector,'B (T)',magnet,z_vector,'none','z_parameter')                                      # create data file, spyview metafile, copy script
        
        counter = 0
        
        for B in B_vector:
            [starttime, counter] = timetrack.start(counter)
            tstart = timetrack.time()
            self.set_B(B)                                                                                                                       # Sets B field
            ivvi.set(dacx,x_vector[0])
            ivvi.set(dacx2,x_vector[0])
            T_mc = self.read_T()                                                                                                                # Read out mixing chamber temperature 
            qt.msleep(delay1)                                                                                                                   # use explained at the bottom of the script
            
            for x in x_vector:
                datavalues = self.take_2data(dacx,dacx2,x)                                                                                             # Go to next sweep value and take data
                data.add_data_point(x,B,0,datavalues[0],datavalues[1],datavalues[2],datavalues[3],datavalues[4],datavalues[5],datavalues[6],datavalues[7],datavalues[8],datavalues[9],T_mc)                           # write datapoint into datafile
            
            timetrack.remainingtime(starttime,Bsteps+1,counter)                                                                                 # Calculate and print remaining scantime
            data.new_block()
            
        data._write_settings_file()                                                                                                             # Overwrite the settings file created at the beginning, this ensures updating the sweep variable with the latest value
        data.close_file()
        qt.mend()        
    
    # To scan a dac as a function of B 
    def _dac_vs_1dac_and_magnet(self,xname,dacx,xstart,xend,xsteps,yname,dacy,dacy_zeroB,dacy_mvperT,Bstart,Bend,Bsteps):
        qt.mstart()
        
        # Create sweep vectors
        x_vector = linspace(xstart,xend,xsteps+1)
        B_vector = linspace(Bstart,Bend,Bsteps+1)
        y_vector = linspace(dacy_zeroB+Bstart*dacy_mvperT,dacy_zeroB+Bend*dacy_mvperT,Bsteps+1)
        z_vector = [0]
        
        data = self.create_data(x_vector,xname,dacx,B_vector,'B (T)',magnet,z_vector,'none','z_parameter')                                     # create data file, spyview metafile, copy script
        
        counter = 0
        
        for i in arange(len(B_vector)):
            B = B_vector[i]
            y = y_vector[i]
            [starttime, counter] = timetrack.start(counter)
            tstart = timetrack.time()
            self.set_B(B)                                                                                                                      # Sets B field
            ivvi.set(dacy,y)
            ivvi.set(dacx,x_vector[0])
            T_mc = self.read_T()                                                                                                                # Read out mixing chamber temperature 
            qt.msleep(delay1)                                                                                                                   # use explained at the bottom of the script
            
            for x in x_vector:
                datavalues = self.take_data(dacx,x)                                                                                             # Go to next sweep value and take data
                data.add_data_point(x,B,0,datavalues[0],datavalues[1],datavalues[2],datavalues[3],datavalues[4],datavalues[5],datavalues[6],datavalues[7],datavalues[8],datavalues[9],T_mc)                           # write datapoint into datafile
            
            timetrack.remainingtime(starttime,Bsteps+1,counter)                                                                                 # Calculate and print remaining scantime
            data.new_block()
            
        data._write_settings_file()                                                                                                             # Overwrite the settings file created at the beginning, this ensures updating the sweep variable with the latest value
        data.close_file()
        qt.mend()
    
    
    # To scan a dac as a function of B and simultaneously sweep 2 dacs.
    def _dac_vs_2dac_and_magnet(self,xname,dacx,xstart,xend,xsteps,yname,dacy,dacy_zeroB,dacy_mvperT,qname,dacq,dacq_zeroB,dacq_mvperT,Bstart,Bend,Bsteps):
        qt.mstart()
        
        # Create sweep vectors
        x_vector = linspace(xstart,xend,xsteps+1)
        B_vector = linspace(Bstart,Bend,Bsteps+1)
        y_vector = linspace(dacy_zeroB+Bstart*dacy_mvperT,dacy_zeroB+Bend*dacy_mvperT,Bsteps+1)
        q_vector = linspace(dacq_zeroB+Bstart*dacq_mvperT,dacy_zeroB+Bend*dacq_mvperT,Bsteps+1)
        z_vector = [0]
        
        data = self.create_data(x_vector,xname,dacx,B_vector,'B (T)',magnet,z_vector,'none','z_parameter')                                     # create data file, spyview metafile, copy script
        
        counter = 0
        
        for i in arange(len(B_vector)):
            B = B_vector[i]
            y = y_vector[i]
            q = q_vector[i]
            [starttime, counter] = timetrack.start(counter)
            tstart = timetrack.time()
            self.set_B(B)                                                                                                                       # Sets B field
            ivvi.set(dacy,y)
            ivvi.set(dacq,q)
            ivvi.set(dacx,x_vector[0])
            T_mc = self.read_T()                                                                                                                # Read out mixing chamber temperature 
            qt.msleep(delay1)                                                                                                                   # use explained at the bottom of the script
            
            for x in x_vector:
                datavalues = self.take_data(dacx,x)                                                                                             # Go to next sweep value and take data
                data.add_data_point(x,B,0,datavalues[0],datavalues[1],datavalues[2],datavalues[3],datavalues[4],datavalues[5],datavalues[6],datavalues[7],datavalues[8],datavalues[9],T_mc)                           # write datapoint into datafile
            
            timetrack.remainingtime(starttime,Bsteps+1,counter)                                                                                 # Calculate and print remaining scantime
            data.new_block()
            
        data._write_settings_file()                                                                                                             # Overwrite the settings file created at the beginning, this ensures updating the sweep variable with the latest value
        data.close_file()
        qt.mend()
    
    
    # To sweep a dac as a function of B, every sweep consists of 2 times a dac sweep (first one from start to end of the sweep vector, 2nd one backwards from end to start of the sweep vector).
    def _fwdbwd_dac_vs_B(self,xname,dacx,xstart,xend,xsteps,Bstart,Bend,Bsteps):
        qt.mstart()
        
        # Create sweep vectors
        x_vector = linspace(xstart,xend,xsteps+1)
        B_vector = linspace(Bstart,Bend,Bsteps+1)
        z_vector = [0]        
        
        data_fwd = self.create_data(x_vector,xname,dacx,B_vector,'B (T)',magnet,z_vector,'none','z_parameter')                                 # create data file, spyview metafile, copy script for fwd sweep direction
        x_vector = x_vector[::-1]                                                                                                               # reverse direction of sweep vector to ensure proper spyview metafile
        data_bwd = self.create_data(x_vector,xname,dacx,B_vector,'B (T)',magnet,z_vector,'none','z_parameter')                                 # create data file, spyview metafile, copy script for bwd sweep direction
        x_vector = x_vector[::-1]                                                                                                               # reverse direction sweep vector back to original
        
        
        counter = 0
                
        for B in B_vector:
            [starttime, counter] = timetrack.start(counter)
            tstart=timetrack.time();
            self.set_B(B)                                                                                                                       # Sets B field
            
            
            for data_loop in (data_fwd, data_bwd):
                
                ivvi.set(dacx,x_vector[0])
                T_mc = self.read_T()                                                                                                            # Read out mixing chamber temperature
                qt.msleep(delay1)
                
                for x in x_vector:
                    datavalues = self.take_data(dacx,x)                                                                                         # Go to next sweep value and take data
                    data_loop.add_data_point(x,B,0,datavalues[0],datavalues[1],datavalues[2],datavalues[3],datavalues[4],datavalues[5],datavalues[6],datavalues[7],datavalues[8],datavalues[9],T_mc)                  # write datapoint into datafile
                    
                data_loop.new_block()
                
                # Toggle forward / backward by reversing vector
                x_vector = x_vector[::-1]
            
            tstop = timetrack.time()
            timetrack.remainingtime(starttime,Bsteps+1,counter)                                                                                 # Calculate and print remaining scantime
            
        for data_loop in (data_fwd, data_bwd):
            data_loop._write_settings_file()                                                                                                    # Overwrite the settings file created at the beginning, this ensures updating the sweep variable with the latest value
            data_loop.close_file()
            
        qt.mend()
        
    
    # Scan a dac as a function of B, while at the same time another dac is stepped linearly, this allows to correct a bit for features affected by both gate and B field so they don't move much.
    
    def _dac_vs_dacmagnet(self,xname,dacx,xstart,xend,xsteps,yname,dacy,ystart,yend,Bstart,Bend,Bsteps):
        qt.mstart()
        
        # Create sweep vectors
        x_vector = linspace(xstart,xend,xsteps+1)
        B_vector = linspace(Bstart,Bend,Bsteps+1)
        z_vector = [0]
        
        data = self.create_data(x_vector,xname,dacx,B_vector,'B (T)',magnet,z_vector,'none','z_parameter')                                     # create data file, spyview metafile, copy script
        
        # Create sweep vector for the dac that needs to be stepped together with B
        y_vector = linspace(ystart,yend,Bsteps+1)
        
        counter = 0
        
        for i in arange(len(B_vector)):
            [starttime, counter] = timetrack.start(counter)
            tstart = timetrack.time()
            B = B_vector[i]
            y = y_vector[i]
            kepco.set_B(B)                                                                                                                      # Specific for kepco as magnet supply
            ivvi.set(dacy,y)
            ivvi.set(dacx,x[0])
            T_mc = self.read_T()                                                                                                                # Read out mixing chamber temperature 
            qt.msleep(delay1)                                                                                                                   # use explained at the bottom of the script
            
            for x in x_vector:
                datavalues = self.take_data(dacx,x)                                                                                             # Go to next sweep value and take data
                data.add_data_point(x,B,0,datavalues[0],datavalues[1],datavalues[2],datavalues[3],datavalues[4],datavalues[5],datavalues[6],datavalues[7],datavalues[8],datavalues[9],T_mc)                           # write datapoint into datafile
            
            timetrack.remainingtime(starttime,Bsteps+1,counter)                                                                                 # Calculate and print remaining scantime
            data.new_block()
            
        data._write_settings_file()                                                                                                             # Overwrite the settings file created at the beginning, this ensures updating the sweep variable with the latest value
        data.close_file()
        qt.mend()
        
    
    # dac vs rf power, to do power dependence of Shapiro steps. rf power is stepped with non-uniform steps following P^2 ~ Vrf. Function only works well if you start the sweep at the lowest power.
    
    def _dac_vs_rfpower(self,xname,dacx,xstart,xend,xsteps,Pstart,Pend,Psteps,freq):
        qt.mstart()
        
        # Create sweep vectors
        x_vector = linspace(xstart,xend,xsteps+1)
        
        # P vector needs to have quadratic shape
        yend = (Pend-Pstart)*(Pend-Pstart)
        y_vector = linspace(0,yend,Psteps+1)
        P_vector = sqrt(y_vector)+Pstart
        
        z_vector = [0]
        
        data = self.create_data(x_vector,xname,dacx,P_vector,'Prf (dB)','MW source',z_vector,'none','z_parameter')                               # create data file, spyview metafile, copy script
        
        counter = 0
        
        # initialization of MW source
        mw.set_power(-20.0)
        mw.set_frequency(freq)
        mw.set_status('ON')
        
        for P in P_vector:
            [starttime, counter] = timetrack.start(counter)
            tstart = timetrack.time()
            mw.set_power(P)                                                                                                                     # Set mw power
            ivvi.set(dacx,x[0])
            T_mc = self.read_T()                                                                                                                # Read out mixing chamber temperature
            qt.msleep(delay1)                                                                                                                   # use explained at the bottom of the script
            
            for x in x_vector:
                datavalues = self.take_data(dacx,x)                                                                                             # Go to next sweep value and take data
                data.add_data_point(x,P,0,datavalues[0],datavalues[1],datavalues[2],datavalues[3],datavalues[4],datavalues[5],datavalues[6],datavalues[7],datavalues[8],datavalues[9],T_mc)                           # write datapoint into datafile
            
            timetrack.remainingtime(starttime,Psteps+1,counter)                                                                                 # Calculate and print remaining scantime
            data.new_block()
        
        mw.set_status('OFF')
        data._write_settings_file()                                                                                                             # Overwrite the settings file created at the beginning, this ensures updating the sweep variable with the latest value
        data.close_file()
        qt.mend()
    
    
    ################# SCANS TO USE WITH AMI430 3D MAGNET #######################   
     
    # Function that transforms an aribtrary B field vector in spherical coordinates to the cartesian coordinate field values and sets it.
    # It takes into account the correction angles defined wrt to positive z and x axis!
    # Sweeping is done in safest possible way: max vector length of 1T is hardcoded, first fields are ramped down if needed, then ramped up.
    # Function written for raw mode of Attila's AMI430 driver. This function should be implemented in an upgrade of this driver!
    
    def _set_3Dfield(self,r,theta,phi):
        
        # first define and read out old field values.
        Xold = AMI430.get_fieldX()
        Yold = AMI430.get_fieldY()
        Zold = AMI430.get_fieldZ()
       
        
        # Compute the real magnet values in x,y,z from the transformed spherical coordinates by taking into account the correction angles.
        
        # First convert all angles to radians
        theta = radians(theta)
        phi = radians(phi)
        p = radians(phi_correction)
        t = radians(theta_correction)        
        
        # Set matrix elements of tranformation matrix. The transformation is as follows: 
        # 1) rotation around z-axis over angle phi_correction
        # 2) basis transformation to x',y',z' over the angle phi_correction. This allows for defining the next rotation in the x',y',z' frame
        # 3) rotation around y-axis over angle theta_correction
        
        
        '''
        R11 = pow(cos(f),2)*(cos(f)*cos(l)+pow(sin(f),2))
        R12 = -sin(f)*(1+cos(l)*pow(cos(f),2)-pow(cos(f),3))
        R13 = sin(l)*cos(f)
        R21 = sin(f)*cos(l)
        R22 = cos(f)*(pow(sin(f),2)+cos(l)*pow(cos(f),2)+pow(cos(f),3)*(1-cos(l)))
        R23 = sin(f)*sin(l)
        R31 = -sin(l)
        R32 = 0
        R33 = cos(l)
        '''
        
        Transformation = matrix([[cos(p)*cos(t),-sin(p),cos(p)*sin(t)],[sin(p)*cos(t),cos(p),sin(p)*sin(t)],[-sin(t),0,cos(t)]])
        
        transformed_new_field = r*matrix([[cos(phi)*sin(theta)],[sin(theta)*sin(phi)],[cos(theta)]])
        
        real_new_field = Transformation*transformed_new_field
        
        Xnew = real_new_field[0,0]
        Ynew = real_new_field[1,0]
        Znew = real_new_field[2,0]
        
        '''
        print Xnew
        print Ynew
        print Znew
        '''
        
        # To sweep safe, we check that total vector length stays below 1T
        
        if power(power(Xnew,2)+power(Ynew,2)+power(Znew,2),0.5) > 1:
            print 'Field value you want to set is too high!!!'
            sys.exit()
        
        
        # Set new field values. Do it in a safe way, first sweep down if possible, then up.
        
        if abs(Xnew) < abs(Xold):                   # We have to compare absolute value, in that way the total vector lenght will stay minimal during sweeping.
            AMI430.set_fieldX(Xnew)                 # Since abs(Xnew)<abs(Xold), we have to set it first.
            
            if abs(Ynew) < abs(Yold):
                AMI430.set_fieldY(Ynew)             # Since abs(Ynew)<abs(Yold), we have to set it first.
                AMI430.set_fieldZ(Znew)             # Since we already set Xnew and Ynew, we can just set Znew now.
            
            else: 
                AMI430.set_fieldZ(Znew)             # We don't need to check if abs(Znew) < abs(Zold) since its the last one anyway, so we can set if first.
                AMI430.set_fieldY(Ynew)             # Safe to set Ynew now.
            
        else:
            
            if abs(Ynew) < abs(Yold):
                AMI430.set_fieldY(Ynew)             # Since abs(Ynew)<abs(Yold), we have to set it first.
                AMI430.set_fieldZ(Znew)             # Since we already checked Xnew and we already set Ynew, we can just set Znew now.
                AMI430.set_fieldX(Xnew)             # We set Xnew as latest since we know it goes up.
            
            else:
                AMI430.set_fieldZ(Znew)             # We don't need to check if abs(Znew) < abs(Zold) since its the last one anyway, so we can set if first.
                AMI430.set_fieldY(Ynew)             # Since both Ynew and Xnew are larger then the old values, it doesn't matter which one we sweep first.
                AMI430.set_fieldX(Xnew)
        
    
    # To scan a dac as a function of B
    def _dac_vs_3Dmagnet(self,xname,dacx,xstart,xend,xsteps,Bstart,Bend,Bsteps,theta,phi):
        qt.mstart()
        
        # Create sweep vectors
        x_vector = linspace(xstart,xend,xsteps+1)
        B_vector = linspace(Bstart,Bend,Bsteps+1)
        z_vector = [0]
        
        data = self.create_data(x_vector,xname,dacx,B_vector,'B) (T',magnet,z_vector,'none','z_parameter')                                      # create data file, spyview metafile, copy script
        
        counter = 0
        
        for B in B_vector:
            [starttime, counter] = timetrack.start(counter)
            tstart = timetrack.time()
            self._set_3Dfield(B,theta,phi)                                                                                                                       # Sets B field
            ivvi.set(dacx,x_vector[0])
            T_mc = self.read_T()                                                                                                                # Read out mixing chamber temperature 
            qt.msleep(delay1)                                                                                                                   # use explained at the bottom of the script
            
            for x in x_vector:
                datavalues = self.take_data(dacx,x)                                                                                             # Go to next sweep value and take data
                data.add_data_point(x,B,0,datavalues[0],datavalues[1],datavalues[2],datavalues[3],datavalues[4],datavalues[5],datavalues[6],datavalues[7],datavalues[8],datavalues[9],T_mc)                           # write datapoint into datafile
            
            timetrack.remainingtime(starttime,Bsteps+1,counter)                                                                                 # Calculate and print remaining scantime
            data.new_block()
            
        data._write_settings_file()                                                                                                             # Overwrite the settings file created at the beginning, this ensures updating the sweep variable with the latest value
        data.close_file()
        qt.mend()
    
    
    
    # Scan dac as a function of theta angle at some fixed B value. theta is defined wrt to positive z-axis. Written for raw mode of AMI430 driver, r is the magnetude of B.
    def _dac_vs_theta(self,xname,dacx,xstart,xend,xsteps,thetastart,thetaend,thetasteps,r,phi):
        qt.mstart()
        
        # Create sweep vectors
        x_vector = linspace(xstart,xend,xsteps+1)
        theta_vector = linspace(thetastart,thetaend,thetasteps+1)
        z_vector = [0]
        data = self.create_data(x_vector,xname,dacx,theta_vector,'theta) (deg','AMI430',z_vector,'none','z_parameter')        # create data file, spyview metafile, copy script
        
        counter = 0
        
        for theta in theta_vector:
            [starttime, counter] = timetrack.start(counter)
            tstart = timetrack.time()
            self._set_3Dfield(r,theta,phi)
            ivvi.set(dacx,x_vector[0])
            T_mc = self.read_T()                                                                                                                # Read out mixing chamber temperature 
            qt.msleep(delay1)                                                                                                                   # use explained at the bottom of the script
            
            for x in x_vector:
                datavalues = self.take_data(dacx,x)                                                                                             # Go to next sweep value and take data
                data.add_data_point(x,theta,0,datavalues[0],datavalues[1],datavalues[2],datavalues[3],datavalues[4],datavalues[5],datavalues[6],datavalues[7],datavalues[8],datavalues[9],T_mc)                           # write datapoint into datafile
            
            timetrack.remainingtime(starttime,thetasteps+1,counter)                                                                                 # Calculate and print remaining scantime
            data.new_block()
            
        data._write_settings_file()                                                                                                             # Overwrite the settings file created at the beginning, this ensures updating the sweep variable with the latest value
        data.close_file()
        qt.mend()
        
        
    
    # Scan dac as a function of phi angle at some fixed B value. Phi is defined wrt to positive x-axis. Written for raw mode of AMI430 driver
    def _dac_vs_phi(self,xname,dacx,xstart,xend,xsteps,phistart,phiend,phisteps,r,theta):
        qt.mstart()
        
        # Create sweep vectors
        x_vector = linspace(xstart,xend,xsteps+1)
        phi_vector = linspace(phistart,phiend,phisteps+1)
        z_vector = [0]
        data = self.create_data(x_vector,xname,dacx,phi_vector,'phi) (deg','AMI430',z_vector,'none','z_parameter')        # create data file, spyview metafile, copy script
        
        counter = 0
        
        for phi in phi_vector:
            [starttime, counter] = timetrack.start(counter)
            tstart = timetrack.time()
            self._set_3Dfield(r,theta,phi)
            ivvi.set(dacx,x_vector[0])
            T_mc = self.read_T()                                                                                                                # Read out mixing chamber temperature 
            qt.msleep(delay1)                                                                                                                   # use explained at the bottom of the script
            
            for x in x_vector:
                datavalues = self.take_data(dacx,x)                                                                                             # Go to next sweep value and take data
                data.add_data_point(x,phi,0,datavalues[0],datavalues[1],datavalues[2],datavalues[3],datavalues[4],datavalues[5],datavalues[6],datavalues[7],datavalues[8],datavalues[9],T_mc)                           # write datapoint into datafile
            
            timetrack.remainingtime(starttime,phisteps+1,counter)                                                                                 # Calculate and print remaining scantime
            data.new_block()
            
        data._write_settings_file()                                                                                                             # Overwrite the settings file created at the beginning, this ensures updating the sweep variable with the latest value
        data.close_file()
        qt.mend()
        
    
    ################# SCANS TO MEASURE A 3 TERMINAL DEVICE BIASING TWO SIDES SIMULTANEOUSLY #########################    
        
    def _dac_vs_dac_twosides(self,xname1,xname2,xstart,xend,xsteps,yname,dacy,ystart,yend,ysteps):
        qt.mstart()
        
        # Create sweep vectors
        x_vector = linspace(xstart,xend,xsteps+1)
        y_vector = linspace(ystart,yend,ysteps+1)
        z_vector = [0]        
        
        data_side1 = self.create_data(x_vector,xname1,biasdac,y_vector,yname,dacy,z_vector,'none','z_parameter')                                 # create data file, spyview metafile, copy script all for lead1 measurement
        data_side2 = self.create_data(x_vector,xname2,biasdac,y_vector,yname,dacy,z_vector,'none','z_parameter')                                 # create data file, spyview metafile, copy script all for lead2 measurement
        
        counter = 0
        
        for y in y_vector:
        
            [starttime, counter] = timetrack.start(counter)
            tstart=timetrack.time();
            ivvi.set(dacy,y)
            
            
            # switch on lead1, turn off lead2
            self.bias_switch('ON','ON','OFF',biasdac,controldac)
            dacx = biasdac
            
            for data_loop in (data_side1, data_side2):
                
                ivvi.set(dacx,x_vector[0])
                T_mc = self.read_T()                                                                                                                   # Read out mixing chamber temperature
                qt.msleep(delay1)
                
                for x in x_vector:
                    datavalues = self.take_data(dacx,x)                                                                                         # Go to next sweep value and take data
                    data_loop.add_data_point(x,y,0,datavalues[0],datavalues[1],datavalues[2],datavalues[3],datavalues[4],datavalues[5],datavalues[6],datavalues[7],datavalues[8],datavalues[9],T_mc)                       # write datapoint into datafile
                    
                data_loop.new_block()
                
                ivvi.set(dacx,0)  # Set bias to zero before switch the controller in order to avoid the voltage jump.
                # switch off lead1, turn on lead2
                self.bias_switch('ON','OFF','ON',biasdac,controldac)

            
            tstop = timetrack.time()
            timetrack.remainingtime(starttime,ysteps+1,counter)                                                                                 # Calculate and print remaining scantime
            
        for data_loop in (data_side1, data_side2):
            data_loop._write_settings_file()                                                                                                    # Overwrite the settings file created at the beginning, this ensures updating the sweep variable with the latest value
            data_loop.close_file()
            
        qt.mend()
    
    
    def _dac_vs_2dacs_twosides(self,xname1,xname2,xstart,xend,xsteps,yname,dacy,ystart,yend,mname,dacm,mstart,mend,ymsteps):
        qt.mstart()
        
        # Create sweep vectors
        x_vector = linspace(xstart,xend,xsteps+1)
        y_vector = linspace(ystart,yend,ymsteps+1)
        z_vector = [0]        
        
        data_lead1 = self.create_data(x_vector,xname1,biasdac_lead1,y_vector,yname,dacy,z_vector,'none','z_parameter')                                 # create data file, spyview metafile, copy script all for lead1 measurement
        data_lead2 = self.create_data(x_vector,xname2,biasdac_lead2,y_vector,yname,dacy,z_vector,'none','z_parameter')                                 # create data file, spyview metafile, copy script all for lead2 measurement
        
        # Define sweep vector for other dac
        m_vector = linspace(mstart,mend,ymsteps+1)
        
        counter = 0
        
        for i in arange(len(y_vector)):
        
            [starttime, counter] = timetrack.start(counter)
            tstart = timetrack.time()
            y = y_vector[i]
            m = m_vector[i]
            ivvi.set(dacy,y)
            ivvi.set(dacm,m)
            
            
            # switch on lead1, turn off lead2
            self.bias_switch('ON','ON','OFF',biasdac_lead1,biasdac_lead2,controldac_lead1,controldac_lead2)
            dacx = biasdac_lead1
            
            for data_loop in (data_lead1, data_lead2):
                
                ivvi.set(dacx,x_vector[0])
                T_mc = self.read_T()                                                                                                                   # Read out mixing chamber temperature
                qt.msleep(delay1)
                
                for x in x_vector:
                    datavalues = self.take_data(dacx,x)                                                                                         # Go to next sweep value and take data
                    data_loop.add_data_point(x,y,0,datavalues[0],datavalues[1],datavalues[2],datavalues[3],datavalues[4],datavalues[5],datavalues[6],datavalues[7],datavalues[8],datavalues[9],T_mc)                       # write datapoint into datafile
                    
                data_loop.new_block()
                
                # switch off lead1, turn off lead2
                self.bias_switch('ON','OFF','ON',biasdac_lead1,biasdac_lead2,controldac_lead1,controldac_lead2)
                dacx = biasdac_lead2
            
            tstop = timetrack.time()
            timetrack.remainingtime(starttime,ymsteps+1,counter)                                                                                 # Calculate and print remaining scantime
            
        for data_loop in (data_lead1, data_lead2):
            data_loop._write_settings_file()                                                                                                    # Overwrite the settings file created at the beginning, this ensures updating the sweep variable with the latest value
            data_loop.close_file()
            
        qt.mend()
    

    def _dac_vs_magnet_twosides(self,xname1,xname2,xstart,xend,xsteps,Bstart,Bend,Bsteps):
        qt.mstart()
        
        # Create sweep vectors
        x_vector = linspace(xstart,xend,xsteps+1)
        B_vector = linspace(Bstart,Bend,Bsteps+1)
        z_vector = [0]        
        
        data_side1 = self.create_data(x_vector,xname1,biasdac,B_vector,'B (T)',magnet,z_vector,'none','z_parameter')                                 # create data file, spyview metafile, copy script all for lead1 measurement
        data_side2 = self.create_data(x_vector,xname2,biasdac,B_vector,'B (T)',magnet,z_vector,'none','z_parameter')                                 # create data file, spyview metafile, copy script all for lead2 measurement
        
        counter = 0
        
        for B in B_vector:
        
            [starttime, counter] = timetrack.start(counter)
            tstart=timetrack.time();
            self.set_B(B)
            
            
            # switch on lead1, turn off lead2
            self.bias_switch('ON','ON','OFF',biasdac,controldac)
            dacx = biasdac
            
            for data_loop in (data_side1, data_side2):
                
                ivvi.set(dacx,x_vector[0])
                T_mc = self.read_T()                                                                                                                   # Read out mixing chamber temperature
                qt.msleep(delay1)
                
                for x in x_vector:
                    datavalues = self.take_data(dacx,x)                                                                                         # Go to next sweep value and take data
                    data_loop.add_data_point(x,B,0,datavalues[0],datavalues[1],datavalues[2],datavalues[3],datavalues[4],datavalues[5],datavalues[6],datavalues[7],datavalues[8],datavalues[9],T_mc)                       # write datapoint into datafile
                    
                data_loop.new_block()
                ivvi.set(dacx,0)  # Set bias to zero before switch the controller in order to avoid the voltage jump.
                # switch off lead1, turn on lead2
                self.bias_switch('ON','OFF','ON',biasdac,controldac)
                dacx = biasdac
            
            tstop = timetrack.time()
            timetrack.remainingtime(starttime,Bsteps+1,counter)                                                                                 # Calculate and print remaining scantime
            
        for data_loop in (data_side1, data_side2):
            data_loop._write_settings_file()                                                                                                    # Overwrite the settings file created at the beginning, this ensures updating the sweep variable with the latest value
            data_loop.close_file()
            
        qt.mend()


    def take_data_for_rampB(self,B_start,B_end,Bsteps): #Hao added
        qt.mstart()
        # Create sweep vectors
        x_vector = linspace(B_start,B_end,Bsteps+1)
        y_vector = [0]
        z_vector = [0]
        
        data = self.create_data(x_vector,'B (T)','magnet',y_vector,'none','y_parameter',z_vector,'none','z_parameter')                                # create data file, spyview metafile, copy script
             
        qt.msleep(delay1)
        self.set_B(B_start)
        qt.msleep(10)  # wait for magnet to reach the starting value
        B_in_mT = B_end*1000  # convert from Tesla to mT
        cryomag.set_field(B_in_mT)
        counter = 0
        while abs(cryomag.get_field()-B_in_mT) > 10:
            qt.msleep(0.02)
            datavalues = self.take_data('dac1',0.0)
            T_mc = self.read_T() 
            B_Now = cryomag.get_field()/1000                                                                                                               
            data.add_data_point(B_Now,0,0,datavalues[0],datavalues[1],datavalues[2],datavalues[3],datavalues[4],datavalues[5],datavalues[6],datavalues[7],datavalues[8],datavalues[9],T_mc)
            counter += 1
            m._Bsweep_rewrite_meta(counter,B_Now)

        data.new_block()
        data._write_settings_file()                                                                                                             # Overwrite the settings file created at the beginning, this ensures updating the sweep variable with the latest value
        data.close_file()
        qt.mend()

    def _Bsweep_rewrite_meta(self,counter,B,col='x'):
        #Overwrite xvector data in meta file (needed because number of points is undetermined before the measurement ends)
        dir = qt.config['datadir']
        fn_meta = dir+'\\'+self.filename_full+'.meta.txt'
        with open(fn_meta,'r') as f:
            meta = f.readlines()

        if col == 'x':
            meta[0] = str(counter)+'\n'
            meta[2] = str(B)+'\n'
        if col == 'y':
            meta[4] = str(counter)+'\n'
            meta[6] = str(B)+'\n'
        with open(fn_meta,'w') as f:
            f.writelines(meta)  


    def take_data_for_rampBX(self,B_start,B_end): #Hao added
        qt.mstart()
        
        # Create sweep vectors
        x_vector = linspace(B_start,B_end,2)
        y_vector = [0]
        z_vector = [0]
        
        data = self.create_data(x_vector,'B','magnet',y_vector,'none','y_parameter',z_vector,'none','z_parameter')                                # create data file, spyview metafile, copy script
             
        qt.msleep(delay1)
        B_in_kG=B_end*10
        Cryomagnetics_4G.set_fieldX(B_in_kG)
        while True:
            qt.msleep(0.02)
            datavalues = self.take_data('dac1',0.0)
            #T_mc = self.read_T() 
            B_Now=Cryomagnetics_4G.get_fieldX()
            B_Now=B_Now/10                                                                                                               # Read out mixing chamber temperature
            data.add_data_point(B_Now,0,0,datavalues[0],datavalues[1],datavalues[2],datavalues[3],datavalues[4],datavalues[5])
            if abs(Cryomagnetics_4G.get_fieldX()-B_in_kG) < 0.01:
                return

        data.new_block()
        data._write_settings_file()                                                                                                             # Overwrite the settings file created at the beginning, this ensures updating the sweep variable with the latest value
        data.close_file()
        qt.mend()   


    def _rampB(self,Bstart,Bend,Bsteps):
        qt.mstart()
        
        # Create sweep vectors, Onder
        x_vector = linspace(Bstart,Bend,Bsteps+1)
        y_vector = [0]
        z_vector = [0]
        
        data = self.create_data(x_vector,'Field',magnet,y_vector,'none','y_parameter',z_vector,'none','z_parameter')                                # create data file, spyview metafile, copy script
        
        m.set_B(x_vector[0])
        qt.msleep(delay1)
        
        for x in x_vector:
            datavalues = self.take_data(dacx,x)                                                                                                 # Go to next sweep value and take data
            T_mc = self.read_T()                                                                                                                # Read out mixing chamber temperature
            data.add_data_point(x,0,0,datavalues[0],datavalues[1],datavalues[2],datavalues[3],datavalues[4],datavalues[5],datavalues[6],datavalues[7],datavalues[8],datavalues[9],T_mc)                               # write datapoint into datafile
        
        data.new_block()
        data._write_settings_file()                                                                                                             # Overwrite the settings file created at the beginning, this ensures updating the sweep variable with the latest value
        data.close_file()
        qt.mend()


    def _B_sweep_X(self,xname,xstart,xend,xrate):
        qt.mstart()
        
        # Create sweep vectors
        x_vector = linspace(xstart,xend,2)
        y_vector = [0]                                                                                                                          # this sweep variable is defined to enable 2D plotting in spyview
        z_vector = [0]
        
        data = self.create_data(x_vector,xname,'T',y_vector,'none','y_parameter',z_vector,'none','z_parameter')                                 # create data file, spyview metafile, copy script

        '''Rxx = qt.Plot2D(data,                 #2014-3-5 stream
					name='Rxx', grid=True,
					coorddim=0, 
					valdim=3, 
					traceofs=10)
                    
        # Gxx = qt.Plot2D(data,
					# name='Gxx', grid=True,
					# coorddim=0, 
					# valdim=5, 
					# traceofs=10)
        
        Rxy = qt.Plot2D(data,        #2014-3-4 stream
					name='Rxy', grid=True,
					coorddim=0, 
					valdim=4, 
					traceofs=10)'''
        
        cryomag.set_rate0X(xrate) #rate in A/s
        cryomag.set_rate1X(0.006) #rate in A/s
        cryomag.set_fieldwaitX(xstart*10.0)
        qt.msleep(2)
        cryomag.set_fieldX(xend*10.0)
        
        while math.fabs( xend*10 - cryomag.get_magnetoutX() ) > 0.001:
            dat = self.take_data() 
            T_mc = self.read_T() 
            B = cryomag.get_magnetoutX()/10.0			
            data.add_data_point(B,0,0,dat[0],dat[1],dat[2],dat[3],dat[4],dat[5],dat[6],dat[7],dat[8],dat[9],dat[10],T_mc)			
		        
        data.new_block()
        data._write_settings_file()                                                                                                             # Overwrite the settings file created at the beginning, this ensures updating the sweep variable with the latest value
        data.close_file()
        qt.mend()

 

    def _B_sweep_Z(self,xname,xstart,xend,xrate):
        qt.mstart()
        
        # Create sweep vectors
        x_vector = linspace(xstart,xend,2)
        y_vector = [0]                                                                                                                          # this sweep variable is defined to enable 2D plotting in spyview
        z_vector = [0]
        
        data = self.create_data(x_vector,xname,'T',y_vector,'none','y_parameter',z_vector,'none','z_parameter')                                 # create data file, spyview metafile, copy script

        '''Rxx = qt.Plot2D(data,                 #2014-3-5 stream
                    name='Rxx', grid=True,
                    coorddim=0, 
                    valdim=3, 
                    traceofs=10)
                    
        # Gxx = qt.Plot2D(data,
                    # name='Gxx', grid=True,
                    # coorddim=0, 
                    # valdim=5, 
                    # traceofs=10)
        
        Rxy = qt.Plot2D(data,        #2014-3-4 stream
                    name='Rxy', grid=True,
                    coorddim=0, 
                    valdim=4, 
                    traceofs=10)'''
        
        cryomag.set_rate0Z(xrate) #rate in A/s
        cryomag.set_rate1Z(0.006) #rate in A/s
        cryomag.set_fieldwaitZ(xstart*10.0)
        qt.msleep(2)
        cryomag.set_fieldZ(xend*10.0)
        
        while math.fabs( xend*10 - cryomag.get_magnetoutZ() ) > 0.001:
            dat = self.take_data() 
            T_mc = self.read_T() 
            B = cryomag.get_magnetoutZ()/10.0           
            data.add_data_point(B,0,0,dat[0],dat[1],dat[2],dat[3],dat[4],dat[5],dat[6],dat[7],dat[8],dat[9],dat[10],T_mc)           
                
        data.new_block()
        data._write_settings_file()                                                                                                             # Overwrite the settings file created at the beginning, this ensures updating the sweep variable with the latest value
        data.close_file()
        qt.mend()

    def _B_sweep_Janis(self,Bname,Bstart,Bend,Brate): #B in T, rate in A/s, max. 0.023 A/s for Janis
        qt.mstart()
        
        # Create sweep vectors
        x_vector = linspace(Bstart,Bend,200)
        y_vector = [0]                                                                                                                          # this sweep variable is defined to enable 2D plotting in spyview
        z_vector = [0]
        
        data = self.create_data(x_vector,Bname,'T',y_vector,'none','y_parameter',z_vector,'none','z_parameter')                                 # create data file, spyview metafile, copy script

        '''Rxx = qt.Plot2D(data,                 #2014-3-5 stream
					name='Rxx', grid=True,
					coorddim=0, 
					valdim=3, 
					traceofs=10)
                    
        # Gxx = qt.Plot2D(data,
					# name='Gxx', grid=True,
					# coorddim=0, 
					# valdim=5, 
					# traceofs=10)
        
        Rxy = qt.Plot2D(data,        #2014-3-4 stream
					name='Rxy', grid=True,
					coorddim=0, 
					valdim=4, 
					traceofs=10)'''
        
        cryomag.set_rate(Brate) #rate in A/s
        
        cryomag.set_field(Bstart*1000.0) #set and get field in mT
        qt.msleep(10)
        current_field = cryomag.get_magnetout() # magnetout in T
        if Bend > current_field: 
            cryomag.set_uplim(Bend+0.005)
            cryomag.sweep_up()
            # start waiting until we reach the desired field
            
            while math.fabs( Bend - cryomag.get_magnetout() ) > 0.001:
                datavalues = self.take_data('dac10',0.0)  #no idea why we would set any dac to zero here, nvm.
                B = cryomag.get_magnetout()
                data.add_data_point(B,0,0,datavalues[0],datavalues[1],datavalues[2],datavalues[3],datavalues[4],datavalues[5],datavalues[6],datavalues[7],datavalues[8],datavalues[9],0)
                #data.add_data_point(B,0,0,dat[0],dat[1],dat[2],dat[3],dat[4],dat[5],dat[6],dat[7],dat[8],dat[9],dat[10],0)
            cryomag.set_sweep('PAUSE')
            # then set the field again to accurately reach the desired value
            cryomag.set_uplim(Bend)
            cryomag.sweep_up()
        elif Bend < current_field: # i.e. we are decreasing the field by more than 20 mT
            cryomag.set_lowlim(Bend-0.005)
            cryomag.sweep_down()
            # start waiting until we reach the desired field
        
            while math.fabs( Bend - cryomag.get_magnetout() ) > 0.001:
                datavalues = self.take_data('dac10',0.0) 
                B = cryomag.get_magnetout()
                data.add_data_point(B,0,0,datavalues[0],datavalues[1],datavalues[2],datavalues[3],datavalues[4],datavalues[5],datavalues[6],datavalues[7],datavalues[8],datavalues[9],0)
                #data.add_data_point(B,0,0,dat[0],dat[1],dat[2],dat[3],dat[4],dat[5],dat[6],dat[7],dat[8],dat[9],dat[10],0)
            cryomag.set_sweep('PAUSE')
            # then set the field again to accurately reach the desired value
            cryomag.set_lowlim(Bend)
            cryomag.sweep_down()			
		        
        data.new_block()
        data._write_settings_file()                                                                                                             # Overwrite the settings file created at the beginning, this ensures updating the sweep variable with the latest value
        data.close_file()
        qt.mend()


#############################################################
#################### INITIALIZATION #########################
#############################################################


# TEMPERATURE READOUT, PLEASE SPECIFY THE APPROPRIATE OPTION BELOW:
    # Add new readout to 'read_T' function
    # Vector Janis: lakeshore
    # 200S set up: 'cryocon'
    # F016 set up: 'lockin3' , make sure yo call the lockin used for T readout 'lockin3'!
    # no T readout: 'off'
# Treadout = 'cryocon'
# Treadout = 'off'
# Treadout = 'lockin3'


# MAGNET SUPPLY 
    # Add new type of supply to 'set_B' function

#magnet = 'kepco'
#magnet = 'OxfordMK3'
#magnet = 'OxfordMK3nodriver'
#magnet = 'AMI430'       # in raw mode right now, only up to 1T!
magnet = 'cryomag'
#magnet = 'Cryomagnetics_4G_X'
# correction angles to set up a new coordinate frame. 

#phi_correction = -33        # Correction angle in degrees counted from positive x-axis in the xy-plane.
#theta_correction = 10.5      # Correction angle in degrees counted from the positive z'-axis around y'-axis in the basis (x',y',z') which is transformed with the phi_correction angle.
phi_correction = 0
theta_correction = 0


'''   
    # 2 TERMINAL READOUT
    
    # I made this function for a 3 terminal device to measure the current to ground via 2 terminals
    # if you bias via the 3th terminal. 
    # Right now it only works if you measure with 2 lockins and 2 keithleys.
    # Column 4 (usual column) contains the data from Lockin1, column
    # 8 contains the data from Lockin2 (as usual), but corrected for gains and series resistances (unusual).
    # This way of implementing it is a bit lame, it would be better to store it in an extra column and also
    # store the raw data, something to be implemented in future.
#two_terminal_measurement = 'ON'                                 # Put 'ON' or 'OFF'

    
    # SWITCHING BIAS
    
    # This mode enables to actively switch between biasing 2 different leads of a 3 terminal device and measure the current
    # to ground via the 3rd of via both 2nd and 3 lead. To do this we use the U1 module, which consists of 2x an input connected 
    # to an output via a MOSFET switch. The switch can be controlled by a low (no currentflow possible) or high (currentflow possible) voltage.
    #
    # Below a list of necessary parameters to operate this module has to be specified.
    
switch_bias = 'OFF'                          # If you use U1 module: always put this one 'ON' otherwise put 'OFF'
switch_bias_mode = 'FLOATING'               # two possible options: 'FLOATING' or 'TWOTERMINAL'
side1 = 'ON'                               # In case you want to measure via 1 lead, but you have the U1 module hooked up, specify here which
side2 = 'OFF'                                # one it will be. In case of 2 leads measurement, put lead1 on (saves one switch in the measure loop)
biasdac = 'dac1'                      # Specify the dac used for biasing lead1
#biasdac_lead2 = 'dac2'                      # Specify the dac used for biasing lead2
controldac= 'dac15'                  # Specify the dac used for controlling lead1
#controldac_lead2 = 'dac16'                  # Specify the dac used for controlling lead2

majorana().bias_switch(switch_bias,side1,side2,biasdac,controldac)

'''


# This delay is needed at the beginning of a sweep, a good value is ~ 10*tau. If you don't use it, first few datapoints of the sweep will be weird. 
# It's safe to put it to 0 for Keithley measurements. 
delay1 = 4

# Delay after setting dac during sweep, you should at least wait 1.5*tau, longer is better. This avoids integration over the previous dac value.
delay2 = 0.3


# DON'T SKIP THIS PART, ITS CRUCIAL FOR PROPER MEASUREMENTS AND DATA PROCESSING!!!

# Gains and ranges
# Please set the gains and ranges before starting measurements. This ensures proper scaling of axis and data in Spyview.
# Make sure that you put the right gain at the right Keithley/Lockin.
GainK1=1e6                       # Gain for Keithley 1
GainK2=1e6                       # Gain for Keithley 2
GainL1=GainK1                       # Gain for Lockin 1
GainL2=GainK2                       # Gain for Lockin 2
Vrange=1e-3                      # voltage range in V/V, first source (changing Dac1 gain)
Vrange2=10e-3                      # voltage range in V/V, second source
Irange=100e-9                    # current range in A/V
BGrange=15                        # Gate range in V/V
Rfilter1 = 2.5e3                  # series resistance of the fridge wire + filtering
Rfilter2 = 2.5e3                  # series resistance of the fridge wire + filtering
Rin1_M1b = 2e3+GainK1*1e-3        # input resistance of the Imeasure unit M1b
Rin2_M1b = 2e3+GainK2*1e-3        # Take care! this is only true if the M1b is set at low noise!
RsL1 = Rin1_M1b+Rfilter1          # total series resistance
RsL2 = Rin2_M1b+Rfilter2          # total series resistance

# INITIALIZATION OF THE LOCKINS

# Lockin1
amplitude1 = 0e-6        # Excitation amplitude in V (this is the A from A*sin(omega*t+B) )
#amplitude1 = 1e-9        # Excitation amplitude in A at the device for current bias measurements
lockin1.set_amplitude(amplitude1/(Vrange*1e-2*sqrt(2)))     # Calculates true output excitation voltage lockin for voltage bias
#lockin1.set_amplitude(amplitude1/(Irange*1e-2*sqrt(2)))     # Calculates true output excitation voltage lockin for current bias
lockin1.set_frequency(13.2)                                 #37.09  _67.91_  77.17 117.13
lockin1.set_phase(180)                                      # the sign flip comes from the preamp?
lockin1.set_sensitivity(22)                                 #16 good for 10 microV excitation #24 needed at high conductance!                  # Check S830 driver for the meaning of this number
lockin1.set_tau(9)                                          # tau = 9 equals 300 ms, check S830 driver for other integration times

#Lockin2
lockin2.set_mode(0)  # This command synchronizes lockin2 with lockin1. 0: synced (master=lockin1, slave=lockin2); 1: lockin2 free
amplitude2 = amplitude1                                           # Excitation amplitude in V (this is the A from A*sin(omega*t+B) )
#lockin2.set_amplitude(amplitude2/(Vrange2*1e-2*sqrt(2)))     # Calculates true output excitation voltage lockin
#lockin2.set_frequency(37.09)
lockin2.set_phase(0)
lockin2.set_sensitivity(13)                                 #16 good for 10 microV excitation #24 needed at high conductance!   
lockin2.set_tau(9)                # Check S830 driver for the meaning of this number

print '\nGainK1='+`GainK1`+'\t\tGain for Keithley 1\nGainK2='+`GainK2`+'\t\tGain for Keithley 2\nGainL1='+`GainL1`+'\t\tGain for Lockin 1\nGainL2='+`GainL2`+'\t\tGain for Lockin 2\nVrange='+`Vrange`+'\t\tVoltage range in V/V\nIrange='+`Irange`+'\t\tCurrent range in A/V\nBGrange='+`BGrange`+'\t\tGate range in V/V\n'
s=raw_input("Ensure smooth dataprocessing in spyview by checking if gains, Vrange, Irange and BGrange are stored correct. Press enter to continue, press any other key and enter to stop: ")
if s!='':
    print '\nVery kind of you to avoid future data processing problems.'
    time.sleep(3.0)
    sys.exit()

# DEFINE MEASUREMENT TYPE 
    # LOCKIN VS KEITHLEY 
    # Please update the number of Keithleys/Lockins used in the measurement, this ensures proper data readout and storage.
    # Remark: In the program its assumed that if you use a single Keithley, this one is Keithley 1. Same for the lockins.
    # To ensure proper data processing, we encourage reading the 'take_data' function above.

Nkeithleys = 1      # Allowed values: 0,1,2
Nlockins = 0  # Allowed values: 0,1,2


#################### MEASUREMENTS #########################

m = majorana()

#4000/2^16=0.06103515625
keithley1.set_nplc(1)
ivvi.set_parameter_rate('dac1',1.220703,2)
ivvi.set_parameter_rate('dac2',1.220703,2)


GateAmp = BGrange
dacIncrement = 0.06103515625 #in mV or in dac
GateRampRate = 0.10 #V per second                                                    !!!!!!!!!CHANGED!!!!!!! it was 0.02

GateRampWaitTime = dacIncrement / (GateRampRate/GateAmp)# in ms
ivvi.set_parameter_rate('dac3',dacIncrement,GateRampWaitTime)

#Cryomagnetics_4G.set_rate0Z(0.012) #default value
#Cryomagnetics_4G.set_rate1Z(0.006)  #default value
#Cryomagnetics_4G.set_rate0Z(0.009)  #
#Cryomagnetics_4G.set_rate1Z(0.006)   #
#Cryomagnetics_4G.set_rate1Z(0.003)  

#Cryomagnetics_4G.set_rate0X(0.024) #1T/15 mins
#Cryomagnetics_4G.set_rate1X(0.012)  #default value

ivvi.get_all()  # initialize dacs in case the previous scan was aborted 

LockinDataProcessingMode = 1 # 0: current bias. 1: voltage bias.
#***********************************************************# 


#wireX
#Vbias (2,11) on dac2
#BG (6) on dac3
#TG1 (9) on dac4
#TG2 (3) on dac5
#TG2 (5) on dac6

filename='Wire X'


ivvi.set_dac2(100)
ivvi.set_dac4(0)
ivvi.set_dac6(0)
ivvi.set_dac3(500)
Nlockins = 0  
m.set_B(8)
m._dac_vs_dac('TG2(1V/V)','dac5',-1800,100,475,'BG(15V/V)','dac3',100,500, 200)

m._dac_vs_magnet('TG2(1V/V)','dac5',-1800,200,1000,8,0,80)
ivvi.set_dac2(500)
m._dac_vs_magnet('TG2(1V/V)','dac5',-1800,200,1000,0,8,80)
ivvi.set_dac2(1000)
m._dac_vs_magnet('TG2(1V/V)','dac5',-1800,200,1000,8,0,80)


ivvi.set_dac2(100)
ivvi.set_dac3(500)
ivvi.set_dac4(0)
ivvi.set_dac5(0)
Nlockins = 0
m.set_B(8)
m._dac_vs_dac('TG3(1V/V)','dac6',-1800,100,475,'BG(15V/V)','dac3',100,500, 200)
m.set_B(7)
m._dac_vs_dac('TG3(1V/V)','dac6',-1800,100,475,'BG(15V/V)','dac3',100,500, 200)
m.set_B(6)
m._dac_vs_dac('TG3(1V/V)','dac6',-1800,100,475,'BG(15V/V)','dac3',100,500, 200)
m.set_B(5)
m._dac_vs_dac('TG3(1V/V)','dac6',-1800,100,475,'BG(15V/V)','dac3',100,500, 200)
m.set_B(4)
m._dac_vs_dac('TG3(1V/V)','dac6',-1800,100,475,'BG(15V/V)','dac3',100,500, 200)
m.set_B(3)
m._dac_vs_dac('TG3(1V/V)','dac6',-1800,100,475,'BG(15V/V)','dac3',100,500, 200)
m.set_B(2)
m._dac_vs_dac('TG3(1V/V)','dac6',-1800,100,475,'BG(15V/V)','dac3',100,500, 200)
m.set_B(1)
m._dac_vs_dac('TG3(1V/V)','dac6',-1800,100,475,'BG(15V/V)','dac3',100,500, 200)
m.set_B(0)
m._dac_vs_dac('TG3(1V/V)','dac6',-1800,100,475,'BG(15V/V)','dac3',100,500, 200)

m._dac_vs_magnet('TG3(1V/V)','dac6',-1800,200,1000,0,8,80)
ivvi.set_dac2(500)
m._dac_vs_magnet('TG3(1V/V)','dac6',-1800,200,1000,8,0,80)
ivvi.set_dac2(1000)
m._dac_vs_magnet('TG3(1V/V)','dac6',-1800,200,1000,0,8,80)





Nlockins = 1 
amplitude1 = 20e-6   
lockin1.set_amplitude(amplitude1/(Vrange*1e-2*sqrt(2)))  
ivvi.set_dac2(100)
ivvi.set_dac4(0)
ivvi.set_dac5(0)
ivvi.set_dac6(0)
ivvi.set_dac3(500)
m.set_B(0)
m._dac_vs_dac('Vbias','dac2', -1500, 1500, 500, 'TG1(1V/V)','dac4',-1500,200,425)
m.set_B(2)
m._dac_vs_dac('Vbias','dac2', -1500, 1500, 500, 'TG1(1V/V)','dac4',-1500,200,425)
m.set_B(4)
m._dac_vs_dac('Vbias','dac2', -1500, 1500, 500, 'TG1(1V/V)','dac4',-1500,200,425)
m.set_B(6)
m._dac_vs_dac('Vbias','dac2', -1500, 1500, 500, 'TG1(1V/V)','dac4',-1500,200,425)
m.set_B(8)
m._dac_vs_dac('Vbias','dac2', -1500, 1500, 500, 'TG1(1V/V)','dac4',-1500,200,425)



ivvi.set_dac2(100)
ivvi.set_dac4(0)
ivvi.set_dac6(0)
ivvi.set_dac3(500)
m.set_B(8)
m._dac_vs_dac('Vbias','dac2', -1500, 1500, 500, 'TG2(1V/V)','dac5',-1500,200,425)
m.set_B(6)
m._dac_vs_dac('Vbias','dac2', -1500, 1500, 500, 'TG2(1V/V)','dac5',-1500,200,425)
m.set_B(4)
m._dac_vs_dac('Vbias','dac2', -1500, 1500, 500, 'TG2(1V/V)','dac5',-1500,200,425)
m.set_B(2)
m._dac_vs_dac('Vbias','dac2', -1500, 1500, 500, 'TG2(1V/V)','dac5',-1500,200,425)
m.set_B(0)
m._dac_vs_dac('Vbias','dac2', -1500, 1500, 500, 'TG2(1V/V)','dac5',-1500,200,425)


ivvi.set_dac2(100)
ivvi.set_dac3(500)
ivvi.set_dac4(0)
ivvi.set_dac5(0)
ivvi.set_dac3(500)
m.set_B(0)
m._dac_vs_dac('Vbias','dac2', -1500, 1500, 500, 'TG3(1V/V)','dac6',-1500,200,425)
m.set_B(2)
m._dac_vs_dac('Vbias','dac2', -1500, 1500, 500, 'TG3(1V/V)','dac6',-1500,200,425)
m.set_B(4)
m._dac_vs_dac('Vbias','dac2', -1500, 1500, 500, 'TG3(1V/V)','dac6',-1500,200,425)
m.set_B(6)
m._dac_vs_dac('Vbias','dac2', -1500, 1500, 500, 'TG3(1V/V)','dac6',-1500,200,425)
m.set_B(8)
m._dac_vs_dac('Vbias','dac2', -1500, 1500, 500, 'TG3(1V/V)','dac6',-1500,200,425)
m.set_B(0)





#wire3
#Vbias on dac2
#BG on dac6
#TG1 (3) on dac4
#TG2 (11) on dac5
#m._dac_vs_dac('TG1(1V/V)','dac4',-600,100, 50,'TG2(1V/V)','dac5',-500,100,30)
#ivvi.set_dac4(0)
#ivvi.set_dac5(0)
#m._dac_vs_dac('TG1(1V/V)','dac4',-600,-100, 50,'BG(15V/V)','dac3',-300,200,50)
#ivvi.set_dac4(0)
#ivvi.set_dac3(0)

#m._single_dac_sweep('BG (1V/V)','dac6', 100 ,-100, 200)

#ivvi.set_dac4(-410)
#ivvi.set_dac5(-410)
#m._dac_vs_dac('Vbias','dac2',700,-700, 140,'BG(1V/V)','dac6',50,800,150)

#ivvi.set_dac4(-390)
#ivvi.set_dac5(-390)
#m._dac_vs_dac('Vbias','dac2',700,-700, 140,'BG(1V/V)','dac6',50,800,150)

#ivvi.set_dac4(-430)
#ivvi.set_dac5(-430)
#m._dac_vs_dac('Vbias','dac2',700,-700, 140,'BG(1V/V)','dac6',50,800,150)

#cryomag.set_heater(1)
#m.set_B(1)
#m._dac_vs_magnet('TG1(1V/V)','dac4',-1000,0,200,0.0,5,25)

#wire4
#Vbias on dac2
#BG on dac3
#TG1 (14) on dac4
#TG2 (4) on dac5
#TG3 (9) on dac6

#Vbias on dac2
#BG on dac3
#TG1 (3) on dac4
#TG2 (11) on dac5

#ivvi.set_dac2(400)
#ivvi.set_dac3(400)
#ivvi.set_dac4(0)
#ivvi.set_dac5(0)

'''
ivvi.set_dac2(0)
m.set_B(0)
m._dac_vs_dac('TG2(1V/V)','dac5',-1800,-850,450,'BG(15V/V)','dac3',80,600, 130)
m.set_B(1)
m._dac_vs_dac('TG2(1V/V)','dac5',-1800,-850,475,'BG(15V/V)','dac3',80,600, 130)
m.set_B(2)
m._dac_vs_dac('TG2(1V/V)','dac5',-1800,-850,475,'BG(15V/V)','dac3',80,600, 130)
m.set_B(3)
m._dac_vs_dac('TG2(1V/V)','dac5',-1800,-850,475,'BG(15V/V)','dac3',80,600, 130)
m.set_B(4)
m._dac_vs_dac('TG2(1V/V)','dac5',-1800,-850,475,'BG(15V/V)','dac3',80,600, 130)
m.set_B(5)
m._dac_vs_dac('TG2(1V/V)','dac5',-1800,-850,475,'BG(15V/V)','dac3',80,600, 130)
m.set_B(6)
m._dac_vs_dac('TG2(1V/V)','dac5',-1800,-850,475,'BG(15V/V)','dac3',80,600, 130)
m.set_B(7)
m._dac_vs_dac('TG2(1V/V)','dac5',-1800,-850,475,'BG(15V/V)','dac3',80,600, 130)
'''

'''
#weak anti-localization
ivvi.set_dac2(400)
#ivvi.set_dac3(-200)
#ivvi.set_dac5(-1650)

ivvi.set_dac3(590)
ivvi.set_dac5(-1600)
m.set_B(0.4)
m._B_sweep_Janis('B',0.4,-0.4,0.01)
m.set_B(-0.4)
ivvi.set_dac5(-1500)
m._B_sweep_Janis('B',-0.4,0.4,0.01)
m.set_B(0.4)
ivvi.set_dac5(-1400)
m._B_sweep_Janis('B',0.4,-0.4,0.01)
m.set_B(-0.4)
ivvi.set_dac5(-1300)
m._B_sweep_Janis('B',-0.4,0.4,0.01)
m.set_B(0.4)
'''
'''
ivvi.set_dac3(0)
m._dac_vs_magnet('TG2(1V/V)','dac5',-400,0,100,-1,1,200)
ivvi.set_dac3(0.05)
m._dac_vs_magnet('TG2(1V/V)','dac5',-400,0,100,-1,1,200)
ivvi.set_dac3(0.1)
m._dac_vs_magnet('TG2(1V/V)','dac5',-400,0,100,-1,1,200)
ivvi.set_dac3(0.15)
m._dac_vs_magnet('TG2(1V/V)','dac5',-400,0,100,-1,1,200)
ivvi.set_dac3(-0.15)
m._dac_vs_magnet('TG2(1V/V)','dac5',-400,0,100,-1,1,200)
ivvi.set_dac3(-0.1)
m._dac_vs_magnet('TG2(1V/V)','dac5',-400,0,100,-1,1,200)
ivvi.set_dac3(-0.05)
m._dac_vs_magnet('TG2(1V/V)','dac5',-400,0,100,-1,1,200)
#m._dac_vs_magnet('BG(15V/V)','dac3',585,595,100,-0.5,0.5,100)
#m._single_dac_sweep('TG2 up (1V/V)','dac5',-600, 0, 50)
'''


'''
ivvi.set_dac3(600)
#m.set_B(6)
#m._dac_vs_dac('Vbias','dac2', -1300, 1300, 500, 'TG2(1V/V)','dac5',-1800,-1100,200)
#m.set_B(5.5)
#m._dac_vs_dac('Vbias','dac2', -1300, 1300, 500, 'TG2(1V/V)','dac5',-1850,-1050,200)
#m.set_B(4)
#m._dac_vs_dac('Vbias','dac2', -1300, 1300, 500, 'TG2(1V/V)','dac5',-1800,-1100,200)
#m.set_B(3.5)
#m._dac_vs_dac('Vbias','dac2', -1300, 1300, 500, 'TG2(1V/V)','dac5',-1850,-1100,200)
#m.set_B(3)
#m._dac_vs_dac('Vbias','dac2', -1300, 1300, 500, 'TG2(1V/V)','dac5',-1800,-1100,200)
#m.set_B(1.5)
#m._dac_vs_dac('Vbias','dac2', -1300, 1300, 500, 'TG2(1V/V)','dac5',-1850,-1050,200)
#m.set_B(1)
#m._dac_vs_dac('Vbias','dac2', -1300, 1300, 500, 'TG2(1V/V)','dac5',-1800,-1100,200)
#m.set_B(0)
#m._dac_vs_dac('Vbias','dac2', -1500, 1500, 500, 'TG2(1V/V)','dac5',-1800,-1100,200)
#m.set_B(5)
#m._dac_vs_dac('Vbias','dac2', -1300, 1300, 500, 'TG2(1V/V)','dac5',-1800,-1100,200)
'''

#ivvi.set_dac2(400)
#m.set_B(7)
#m._dac_vs_dac('TG2(1V/V)','dac5',-1200,-300,225,'BG(15V/V)','dac3',-400,400, 200)
#m.set_B(5)
#m._dac_vs_dac('TG2(1V/V)','dac5',-1200,-300,225,'BG(15V/V)','dac3',-400,400, 200)
#m.set_B(0)
#ivvi.set_dac3(500)

'''
ivvi.set_dac2(-1600)
ivvi.set_dac3(600)
m._single_dac_sweep('TG2 up (1V/V)','dac5',-1900, -800, 700)
'''
'''
ivvi.set_dac3(600)
m.set_B(7)
m._dac_vs_dac('Vbias','dac2', -1600, 1600, 500, 'TG2(1V/V)','dac5',-1900,-800,275)
m.set_B(5)
m._dac_vs_dac('Vbias','dac2', -1300, 1300, 500, 'TG2(1V/V)','dac5',-1900,-1100,200)
m.set_B(3)
m._dac_vs_dac('Vbias','dac2', -1300, 1300, 500, 'TG2(1V/V)','dac5',-1900,-1000,200)
m.set_B(1)
m._dac_vs_dac('Vbias','dac2', -1300, 1300, 500, 'TG2(1V/V)','dac5',-1900,-1000,200)
m.set_B(0)
m._dac_vs_dac('Vbias','dac2', -1300, 1300, 500, 'TG2(1V/V)','dac5',-1900,-1000,200)
m.set_B(0)
'''

#TG2
'''
ivvi.set_dac4(0)
ivvi.set_dac5(0)

ivvi.set_dac3(900)


m.set_B(1)
m._dac_vs_dac('TG2(5V/V)','dac5',-550,-320,115,'BG(15V/V)','dac3',600,900, 150)
m.set_B(3)
m._dac_vs_dac('TG2(5V/V)','dac5',-550,-320,115,'BG(15V/V)','dac3',600,900, 150)
m.set_B(5)
m._dac_vs_dac('TG2(5V/V)','dac5',-550,-320,115,'BG(15V/V)','dac3',600,900, 150)
m.set_B(8)
m._dac_vs_dac('TG2(5V/V)','dac5',-550,-320,115,'BG(15V/V)','dac3',600,900, 150)
m.set_B(0)
'''

#ivvi.set_dac2(300)
#m._dac_vs_magnet('TG1(5V/V)','dac4',-510,-210,300,0,7,35)


#ivvi.set_dac7(2000)

#m._single_dac_sweep('BG up (15V/V)','dac3',-400, 400, 400)
#m._single_dac_sweep('BG down (15V/V)','dac3',400, -400, 400)
#ivvi.set_dac3(0)
#m._single_dac_sweep('TG1 up (1V/V)','dac4', -500, 500, 500)
#m._single_dac_sweep('TG1 down (1V/V)','dac4',0, -1000, 500)
#ivvi.set_dac4(0)
#m._single_dac_sweep('TG2 up (1V/V)','dac5',-500, 500, 500)
#m._single_dac_sweep('TG2 down (1V/V)','dac5',500, -500, 500)
#ivvi.set_dac5(0)
#m._single_dac_sweep('TG3 up (1V/V)','dac6',-400, 400, 400)
#m._single_dac_sweep('TG3 down (1V/V)','dac6',400, -400, 400)
#ivvi.set_dac6(0)


#m._dac_vs_dac('TG1(1V/V)','dac4',-500,100, 60,'TG2(1V/V)','dac5',-500,100,60)
#ivvi.set_dac4(0)
#m._dac_vs_dac('TG2(1V/V)','dac5',-500,100, 60,'TG3(1V/V)','dac6',-500,100,60)
#ivvi.set_dac5(0)
#m._dac_vs_dac('TG1(1V/V)','dac4',-500,100, 60,'TG3(1V/V)','dac6',-500,100,60)
#ivvi.set_dac6(0)

#m._dac_vs_dac('TG1(1V/V)','dac4',-500,100,60,'BG(15V/V)','dac3',-400,300, 30)
#ivvi.set_dac4(0)
#m._dac_vs_dac('TG2(1V/V)','dac5',-500,100,60,'BG(15V/V)','dac3',-400,300, 30)
#ivvi.set_dac5(0)
#m._dac_vs_dac('TG3(1V/V)','dac6',-500,100,60,'BG(15V/V)','dac3',-400,300, 30)
#ivvi.set_dac6(0)
#ivvi.set_dac3(0)
#ivvi.set_dac2(0)


#ivvi.set_dac2(0)
#ivvi.set_dac3(200)
#ivvi.set_dac4(-450)
#ivvi.set_dac6(-450)
#m._dac_vs_dac('Vbias','dac2',700,-700, 50,'TG2(1V/V)','dac5',-200,800,50)
#m._single_dac_sweep('BG(1V/V)','dac3', 200, 600, 300)
#ivvi.set_dac4(-410)
#ivvi.set_dac5(-410)
#m._single_dac_sweep('BG(1V/V)','dac3', 600, 200, 300)
#ivvi.set_dac4(-430)
#ivvi.set_dac5(-430)
#m._single_dac_sweep('BG(1V/V)','dac3', 200, 600, 300)
#m._dac_vs_dac('Vbias','dac2',-70,70, 140,'BG2(15V/V)','dac7',300,270,100)
#cryomag.set_heater(1)
#m.set_B(1)
#m._dac_vs_magnet('TG1(1V/V)','dac4',-700,-300,200,0.0,5,25)

'''
filename='wire4'
#ivvi.set_dac2(600)

ivvi.set_dac4(0)
#ivvi.set_dac5(0)
ivvi.set_dac6(0)
#ivvi.set_dac7(2000)
cryomag.set_heater(1)

ivvi.set_dac3(500)
m.set_B(8)
m._dac_vs_dac('Vbias','dac2', -1000, 1000, 500, 'TG2(1V/V)','dac5',-915,-1030, 115)
#m.set_B(7)
#m._dac_vs_dac('Vbias','dac2', -1500, 1500, 60, 'TG2(1V/V)','dac5',-450, -1050, 60)
m.set_B(6)
m._dac_vs_dac('Vbias','dac2', -1000, 1000, 500, 'TG2(1V/V)','dac5',-915,-1030, 115)
#m.set_B(5)
#m._dac_vs_dac(''Vbias','dac2', -1500, 1500, 60, 'TG2(1V/V)','dac5',-450, -1050, 60)
m.set_B(4)
m._dac_vs_dac('Vbias','dac2', -1000, 1000, 500, 'TG2(1V/V)','dac5',-915,-1070, 155)
#m.set_B(3)
#m._dac_vs_dac('Vbias','dac2', -1500, 1500, 60, 'TG2(1V/V)','dac5',-450, -1050, 60)
m.set_B(2)
m._dac_vs_dac('Vbias','dac2', -1000, 1000, 500, 'TG2(1V/V)','dac5',-915,-1070, 155)
#m.set_B(1)
#m._dac_vs_dac('Vbias','dac2', -1500, 1500, 60, 'TG2(1V/V)','dac5',-450, -1050, 60)
m.set_B(0)
m._dac_vs_dac('Vbias','dac2', -1000, 1000, 500, 'TG2(1V/V)','dac5',-915,-1130, 215)
ivvi.set_dac2(0)
ivvi.set_dac3(0)
ivvi.set_dac5(0)
'''
#m._dac_vs_magnet('TG3(1V/V)','dac6',-250,-900,200,5,0,25)
#ivvi.set_dac6(0)
#m._dac_vs_magnet('TG2(1V/V)','dac5',-300,-1050,1500,0,8,80)
#ivvi.set_dac5(0)
#m._dac_vs_magnet('TG3(1V/V)','dac6',-200,-900,2100,8,0,80)
#ivvi.set_dac6(0)
#m._dac_vs_magnet('TG1(1V/V)','dac4',-300,-700,1200,8,0,80)
#ivvi.set_dac4(0)
#ivvi.set_dac2(0)
#ivvi.set_dac3(0)



#m._dac_vs_magnet('TG1(1V/V)','dac4',-300,-700,400,5,0,50)
#ivvi.set_dac2(100)
#m._dac_vs_magnet('TG1(1V/V)','dac4',-700,-300,400,0,5,50)
#ivvi.set_dac2(0)
#m._dac_vs_magnet('TG1(1V/V)','dac4',-300,-700,400,5,0,50)
#ivvi.set_dac4(0)
#ivvi.set_dac2(200)
#m._dac_vs_magnet('TG2(1V/V)','dac5',-700,-300,200,0,5,50)



#m._single_dac_sweep('TG2@(1V/V)','dac5', -650, -1050, 400)
#ivvi.set_dac2(0)
#m._dac_vs_magnet('TG2(1V/V)','dac5',-450,-950,100,5,10)
#ivvi.set_dac5(0)
#ivvi.set_dac2(200)
#m._dac_vs_magnet('TG3(1V/V)','dac6',-250,-50,200,0,5,25)
#ivvi.set_dac2(0)
#m._dac_vs_magnet('TG3(1V/V)','dac6',-250,-50,200,5,0,25)
#ivvi.set_dac6(0)
#ivvi.set_dac3(0)
#m.set_B(0)
#cryomag.set_heater(0)
#m._single_dac_sweep('TG3@(1V/V)','dac6', -650, -250, 400)

#ivvi.set_dac2(0)
#ivvi.set_dac4(-250)
#ivvi.set_dac5(-250)
#ivvi.set_dac6(0)
#m._dac_vs_dac('Vbias','dac2',-50,50, 200,'BG(1V/V)','dac7',1800,2000,400)
#ivvi.set_dac4(-200)
#ivvi.set_dac5(-200)
#ivvi.set_dac6(0)
#m._dac_vs_dac('Vbias','dac2',-50,50, 200,'BG(1V/V)','dac7',1800,2000,400)
#ivvi.set_dac4(-150)
#ivvi.set_dac5(-150)
#ivvi.set_dac6(0)
#m._dac_vs_dac('Vbias','dac2',-50,50, 200,'BG(1V/V)','dac7',1800,2000,400)
#ivvi.set_dac4(0)
#ivvi.set_dac5(0)
#ivvi.set_dac6(0)

#m._single_dac_sweep('BG(1V/V)','dac7', 1000, 2000, 500)
#***********************************************************# 
#ivvi.set_dac2(100) # Keithley2 data can be used (apply lowpass in X first)
#ivvi.set_dac2(1000)
#m._time_sweep(time_steps=2400, time_interval=10)
#m._single_dac_sweep('BG 15V/V)','dac3',450, -320, 770)
#m._single_dac_sweep('BG 15V/V)','dac3',-320, 450, 770)
#ivvi.set_dac2(100)
#m._single_dac_sweep('BG 15V/V)','dac3',450, -320, 770)
#m._single_dac_sweep('BG 15V/V)','dac3',-320, 450, 770)
#m._single_dac_sweep('Top gate(15V/V)','dac3',-300,300,300)
#m._single_dac_sweep('Top gate(15V/V)','dac3',-250,0,100)
#m._single_dac_sweep('SD current(10nA/V)','dac2',0,100,100) # read columns 6 and 7
#m._dac_vs_magnet('Top gate (15V/V)','dac3',50,-50,10,-0.3,0.3,300)
#ivvi.set_dac1(0)
#ivvi.set_dac2(0)
#ivvi.set_dac3(0)
#Cryomagnetics_4G.set_fieldZ(0)


#m._single_dac_sweep('Vbias(10mV/V)','dac1',-200,200,200)

#m._dac_vs_magnet('BG(15V/V)','dac3',-40,360,250,0.0,3.8,38)
#m._single_dac_sweep('BG(30V/V)','dac3',-1000,1000,1000)
#m._single_dac_sweep('Bias(10mV/V)','dac1',-150,160,400)
#m._dac_vs_dac('Vbias(10mV/V)','dac1',-100,110,301,'BG(15V/V)','dac3',-0,200,300)
#m._2dacs_vs_dac('Vbias','dac1','dac2',-100,100,400,'BG(30V/V)','dac3',-600,-530,70)
#m._rampB(0,8.5,500)
#m.take_data_for_rampB(0.25,0)



# remark: You cannot take more than 16 pnts/mV on a dac. 4000mV/2^16 = 0.061, below that stepsize you hit dac quantization.
#m._dac_vs_magnet('Top gate (15V/V)','dac3',300,-300,100,0,5,200)
#m.set_B(0)
#ivvi.set_dac1(0)
#ivvi.set_dac2(0)
#ivvi.set_dac3(0)
#qt.msleep(2.0)
#m._dac_vs_3dacs('Vbias','dac1',-200,200,200,'BG1','dac8',0,400,'BG2','dac9',0,400,'BG3','dac10',0,400,200)
#m._dac_vs_dac('Vbias(x100mV/V)','dac1',-300,300,300,'BG(x30V/V)','dac3',100,1000,700)
#m._dac_vs_magnet('BG(x30V/V)','dac3',0,500,500,0.0,8.5,85)

#m.set_B(0)
#Cryomagnetics_4G.set_heaterZ(0)


